/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.statistics.collectors;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.values.IntVectorValue;
import org.vitrivr.cottontail.dbms.statistics.collectors.MetricsConfig;
import org.vitrivr.cottontail.dbms.statistics.collectors.RealVectorMetricsCollector;
import org.vitrivr.cottontail.dbms.statistics.values.IntVectorValueStatistics;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001c\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0002H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0019\u0010\n\u001a\u00020\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\u000e\u001a\u00020\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000f\u0010\fR\u0019\u0010\u0010\u001a\u00020\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u0011\u0010\f\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001b"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/collectors/IntVectorMetricsCollector;", "Lorg/vitrivr/cottontail/dbms/statistics/collectors/RealVectorMetricsCollector;", "Lorg/vitrivr/cottontail/core/values/IntVectorValue;", "logicalSize", "", "config", "Lorg/vitrivr/cottontail/dbms/statistics/collectors/MetricsConfig;", "(ILorg/vitrivr/cottontail/dbms/statistics/collectors/MetricsConfig;)V", "getLogicalSize", "()I", "max", "getMax-NP4WLaU", "()[I", "[I", "min", "getMin-NP4WLaU", "sum", "getSum-NP4WLaU", "calculate", "Lorg/vitrivr/cottontail/dbms/statistics/values/IntVectorValueStatistics;", "probability", "", "receive", "", "value", "receive-wMGn9Ig", "([I)V", "cottontaildb-dbms"})
public final class IntVectorMetricsCollector
extends RealVectorMetricsCollector<IntVectorValue> {
    private final int logicalSize;
    @NotNull
    private final int[] min;
    @NotNull
    private final int[] max;
    @NotNull
    private final int[] sum;

    public IntVectorMetricsCollector(int logicalSize, @NotNull MetricsConfig config) {
        int n;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super((Types)new Types.IntVector(logicalSize), config, null);
        this.logicalSize = logicalSize;
        int n2 = 0;
        int n3 = this.logicalSize;
        int[] nArray = new int[n3];
        IntVectorMetricsCollector intVectorMetricsCollector = this;
        while (n2 < n3) {
            n = n2++;
            nArray[n] = Integer.MAX_VALUE;
        }
        intVectorMetricsCollector.min = IntVectorValue.constructor-impl((int[])nArray);
        n2 = 0;
        n3 = this.logicalSize;
        nArray = new int[n3];
        intVectorMetricsCollector = this;
        while (n2 < n3) {
            n = n2++;
            nArray[n] = Integer.MIN_VALUE;
        }
        intVectorMetricsCollector.max = IntVectorValue.constructor-impl((int[])nArray);
        this.sum = IntVectorValue.constructor-impl((int[])new int[this.logicalSize]);
    }

    public final int getLogicalSize() {
        return this.logicalSize;
    }

    @NotNull
    public final int[] getMin-NP4WLaU() {
        return this.min;
    }

    @NotNull
    public final int[] getMax-NP4WLaU() {
        return this.max;
    }

    @NotNull
    public final int[] getSum-NP4WLaU() {
        return this.sum;
    }

    public void receive-wMGn9Ig(@Nullable int[] value) {
        super.receive(value != null ? IntVectorValue.box-impl((int[])value) : null);
        if (value != null) {
            int[] nArray = value;
            int n = nArray.length;
            for (int j = 0; j < n; ++j) {
                int i2 = j;
                int d = nArray[j];
                this.min[i2] = Integer.min(d, this.min[i2]);
                this.max[i2] = Integer.max(d, this.max[i2]);
                int[] nArray2 = this.sum;
                nArray2[i2] = nArray2[i2] + d;
            }
        }
    }

    @NotNull
    public IntVectorValueStatistics calculate(float probability) {
        IntVectorValueStatistics sampleMetrics = new IntVectorValueStatistics(this.logicalSize, this.getNumberOfNullEntries(), this.getNumberOfNonNullEntries(), this.getNumberOfDistinctEntries(), this.min, this.max, this.sum, null);
        return new IntVectorValueStatistics(1.0f / probability, sampleMetrics);
    }
}

