/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.statistics.collectors;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.types.RealValue;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.types.Value;
import org.vitrivr.cottontail.dbms.statistics.collectors.AbstractScalarMetricsCollector;
import org.vitrivr.cottontail.dbms.statistics.collectors.MetricsConfig;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u001a\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\b\u0004\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J\u0017\u0010,\u001a\u00020)2\b\u0010-\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010.R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R\u001a\u0010\u0019\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0013\"\u0004\b\u001b\u0010\u0015R\u001a\u0010\u001c\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0013\"\u0004\b\u001e\u0010\u0015R\u001a\u0010\u001f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0013\"\u0004\b!\u0010\u0015R\u001a\u0010\"\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0013\"\u0004\b$\u0010\u0015R\u001a\u0010%\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0013\"\u0004\b'\u0010\u0015\u0082\u0001\u0006/01234\u00a8\u00065"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/collectors/RealMetricsCollector;", "T", "Lorg/vitrivr/cottontail/core/types/RealValue;", "Lorg/vitrivr/cottontail/dbms/statistics/collectors/AbstractScalarMetricsCollector;", "type", "Lorg/vitrivr/cottontail/core/types/Types;", "config", "Lorg/vitrivr/cottontail/dbms/statistics/collectors/MetricsConfig;", "(Lorg/vitrivr/cottontail/core/types/Types;Lorg/vitrivr/cottontail/dbms/statistics/collectors/MetricsConfig;)V", "d_M2", "", "d_M3", "d_M4", "d_count", "", "d_mean", "d_sum", "kurtosis", "getKurtosis", "()D", "setKurtosis", "(D)V", "max", "getMax", "setMax", "mean", "getMean", "setMean", "min", "getMin", "setMin", "skewness", "getSkewness", "setSkewness", "sum", "getSum", "setSum", "variance", "getVariance", "setVariance", "processMoments", "", "num", "", "receive", "value", "(Lorg/vitrivr/cottontail/core/types/RealValue;)V", "Lorg/vitrivr/cottontail/dbms/statistics/collectors/ByteMetricsCollector;", "Lorg/vitrivr/cottontail/dbms/statistics/collectors/DoubleMetricsCollector;", "Lorg/vitrivr/cottontail/dbms/statistics/collectors/FloatMetricsCollector;", "Lorg/vitrivr/cottontail/dbms/statistics/collectors/IntMetricsCollector;", "Lorg/vitrivr/cottontail/dbms/statistics/collectors/LongMetricsCollector;", "Lorg/vitrivr/cottontail/dbms/statistics/collectors/ShortMetricsCollector;", "cottontaildb-dbms"})
public abstract class RealMetricsCollector<T extends RealValue<?>>
extends AbstractScalarMetricsCollector<T> {
    private double min = Double.MAX_VALUE;
    private double max = Double.MIN_VALUE;
    private double sum;
    private double mean;
    private double variance;
    private double skewness;
    private double kurtosis;
    private int d_count;
    private double d_sum;
    private double d_mean;
    private double d_M2;
    private double d_M3;
    private double d_M4;

    private RealMetricsCollector(Types<T> type, MetricsConfig config) {
        super(type, config, null);
    }

    public final double getMin() {
        return this.min;
    }

    public final void setMin(double d) {
        this.min = d;
    }

    public final double getMax() {
        return this.max;
    }

    public final void setMax(double d) {
        this.max = d;
    }

    public final double getSum() {
        return this.sum;
    }

    public final void setSum(double d) {
        this.sum = d;
    }

    public final double getMean() {
        return this.mean;
    }

    public final void setMean(double d) {
        this.mean = d;
    }

    public final double getVariance() {
        return this.variance;
    }

    public final void setVariance(double d) {
        this.variance = d;
    }

    public final double getSkewness() {
        return this.skewness;
    }

    public final void setSkewness(double d) {
        this.skewness = d;
    }

    public final double getKurtosis() {
        return this.kurtosis;
    }

    public final void setKurtosis(double d) {
        this.kurtosis = d;
    }

    @Override
    public void receive(@Nullable T value) {
        super.receive((Value)value);
        if (value != null) {
            this.processMoments(value.getValue());
            this.min = Double.min(value.getValue().doubleValue(), this.min);
            this.max = Double.max(value.getValue().doubleValue(), this.max);
            this.sum += value.getValue().doubleValue();
        }
    }

    private final void processMoments(Number num) {
        long number = num.longValue();
        double delta = (double)number - this.d_mean;
        int nm1 = this.d_count;
        this.d_sum += (double)number;
        int n = this.d_count;
        int n2 = this.d_count = n + 1;
        int n22 = n2 * n2;
        double deltaN = delta / (double)n2;
        this.d_mean = this.d_sum / (double)n2;
        double term1 = delta * deltaN * (double)nm1;
        double deltaN2 = deltaN * deltaN;
        this.d_M4 += term1 * deltaN2 * ((double)n22 - 3.0 * (double)n2 + 3.0) + (double)6 * deltaN2 * this.d_M2 - 4.0 * deltaN * this.d_M3;
        this.d_M3 += term1 * deltaN * ((double)n2 - 2.0) - 3.0 * deltaN * this.d_M2;
        this.d_M2 += term1;
        this.mean = 1 <= this.d_count ? this.d_mean : 0.0;
        double d = this.variance = 2 <= this.d_count ? this.d_M2 / (double)(this.d_count - 1) : 0.0;
        if (3 <= this.d_count && !(0.0 == this.d_M2)) {
            double d_count_double = this.d_count;
            this.skewness = Math.sqrt(d_count_double - 1.0) * d_count_double / (d_count_double - (double)2) * this.d_M3 / Math.pow(this.d_M2, 1.5);
        }
        if (4 <= this.d_count && !(this.d_M2 == 0.0)) {
            double n1 = (double)this.d_count - 1.0;
            double n2n3 = ((double)n2 - 2.0) * ((double)n2 - 3.0);
            this.kurtosis = (double)n2 * ((double)n2 + 1.0) * n1 / n2n3 * this.d_M4 / this.d_M2 / this.d_M2 - 3.0 * n1 * n1 / n2n3;
        } else {
            this.kurtosis = 0.0;
        }
    }

    public /* synthetic */ RealMetricsCollector(Types type, MetricsConfig config, DefaultConstructorMarker $constructor_marker) {
        this(type, config);
    }
}

