/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.statistics.storage;

import java.io.Closeable;
import java.io.File;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentConfig;
import jetbrains.exodus.env.Environments;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.config.Config;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.dbms.catalogue.entries.NameBinding;
import org.vitrivr.cottontail.dbms.statistics.metrics.EntityMetric;
import org.vitrivr.cottontail.dbms.statistics.storage.ColumnStatistic;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0086\u0002J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0014J\u0016\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/storage/StatisticsStorageManager;", "Ljava/io/Closeable;", "config", "Lorg/vitrivr/cottontail/config/Config;", "(Lorg/vitrivr/cottontail/config/Config;)V", "columnsStore", "Ljetbrains/exodus/env/Store;", "environment", "Ljetbrains/exodus/env/Environment;", "metricsStore", "close", "", "deleteColumnStatistic", "column", "Lorg/vitrivr/cottontail/core/database/Name$ColumnName;", "deleteMetric", "", "entity", "Lorg/vitrivr/cottontail/core/database/Name$EntityName;", "get", "Lorg/vitrivr/cottontail/dbms/statistics/storage/ColumnStatistic;", "getMetric", "Lorg/vitrivr/cottontail/dbms/statistics/metrics/EntityMetric;", "setColumnStatistic", "name", "statistic", "setMetric", "metric", "cottontaildb-dbms"})
@SourceDebugExtension(value={"SMAP\nStatisticsStorageManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatisticsStorageManager.kt\norg/vitrivr/cottontail/dbms/statistics/storage/StatisticsStorageManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n1#2:110\n*E\n"})
public final class StatisticsStorageManager
implements Closeable {
    @NotNull
    private final Environment environment;
    @NotNull
    private final Store columnsStore;
    @NotNull
    private final Store metricsStore;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatisticsStorageManager(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        File file = config.statisticsFolder().toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        this.environment = Environments.newInstance((File)file, (EnvironmentConfig)config.getXodus().toEnvironmentConfig());
        Transaction transaction = this.environment.beginExclusiveTransaction();
        Intrinsics.checkNotNullExpressionValue((Object)transaction, (String)"beginExclusiveTransaction(...)");
        Transaction tx = transaction;
        try {
            Store store = this.environment.openStore("org.vitrivr.cottontail.statistics.column", StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING, tx);
            Intrinsics.checkNotNullExpressionValue((Object)store, (String)"openStore(...)");
            this.columnsStore = store;
            Store store2 = this.environment.openStore("org.vitrivr.cottontail.statistics.entity", StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING, tx);
            Intrinsics.checkNotNullExpressionValue((Object)store2, (String)"openStore(...)");
            this.metricsStore = store2;
        }
        finally {
            tx.commit();
        }
    }

    @Nullable
    public final ColumnStatistic get(@NotNull Name.ColumnName column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        return (ColumnStatistic)this.environment.computeInReadonlyTransaction(arg_0 -> StatisticsStorageManager.get$lambda$1(this, column, arg_0));
    }

    @Nullable
    public final EntityMetric getMetric(@NotNull Name.EntityName entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return (EntityMetric)this.environment.computeInReadonlyTransaction(arg_0 -> StatisticsStorageManager.getMetric$lambda$3(this, entity, arg_0));
    }

    public final boolean setMetric(@NotNull Name.EntityName entity, @NotNull EntityMetric metric) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        Object object = this.environment.computeInExclusiveTransaction(arg_0 -> StatisticsStorageManager.setMetric$lambda$4(this, entity, metric, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"computeInExclusiveTransaction(...)");
        return (Boolean)object;
    }

    public final boolean deleteMetric(@NotNull Name.EntityName entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object object = this.environment.computeInExclusiveTransaction(arg_0 -> StatisticsStorageManager.deleteMetric$lambda$5(this, entity, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"computeInExclusiveTransaction(...)");
        return (Boolean)object;
    }

    public final void setColumnStatistic(@NotNull Name.ColumnName name, @NotNull ColumnStatistic statistic) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)statistic, (String)"statistic");
        this.environment.executeInExclusiveTransaction(arg_0 -> StatisticsStorageManager.setColumnStatistic$lambda$6(this, name, statistic, arg_0));
    }

    public final void deleteColumnStatistic(@NotNull Name.ColumnName column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        this.environment.executeInExclusiveTransaction(arg_0 -> StatisticsStorageManager.deleteColumnStatistic$lambda$7(this, column, arg_0));
    }

    @Override
    public void close() {
        this.environment.close();
    }

    private static final ColumnStatistic get$lambda$1(StatisticsStorageManager this$0, Name.ColumnName $column, Transaction tx) {
        ColumnStatistic columnStatistic;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$column, (String)"$column");
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        ByteIterable byteIterable = this$0.columnsStore.get(tx, NameBinding.Column.INSTANCE.toEntry($column));
        if (byteIterable != null) {
            ByteIterable it = byteIterable;
            boolean bl = false;
            columnStatistic = ColumnStatistic.Companion.entryToObject(it);
        } else {
            columnStatistic = null;
        }
        return columnStatistic;
    }

    private static final EntityMetric getMetric$lambda$3(StatisticsStorageManager this$0, Name.EntityName $entity, Transaction tx) {
        EntityMetric entityMetric;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$entity, (String)"$entity");
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        ByteIterable byteIterable = this$0.metricsStore.get(tx, NameBinding.Entity.INSTANCE.toEntry($entity));
        if (byteIterable != null) {
            ByteIterable it = byteIterable;
            boolean bl = false;
            entityMetric = EntityMetric.Companion.entryToObject(it);
        } else {
            entityMetric = null;
        }
        return entityMetric;
    }

    private static final Boolean setMetric$lambda$4(StatisticsStorageManager this$0, Name.EntityName $entity, EntityMetric $metric, Transaction tx) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$entity, (String)"$entity");
        Intrinsics.checkNotNullParameter((Object)$metric, (String)"$metric");
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        return this$0.metricsStore.put(tx, NameBinding.Entity.INSTANCE.toEntry($entity), (ByteIterable)EntityMetric.Companion.objectToEntry($metric));
    }

    private static final Boolean deleteMetric$lambda$5(StatisticsStorageManager this$0, Name.EntityName $entity, Transaction tx) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$entity, (String)"$entity");
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        return this$0.metricsStore.delete(tx, NameBinding.Entity.INSTANCE.toEntry($entity));
    }

    private static final void setColumnStatistic$lambda$6(StatisticsStorageManager this$0, Name.ColumnName $name, ColumnStatistic $statistic, Transaction tx) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
        Intrinsics.checkNotNullParameter((Object)$statistic, (String)"$statistic");
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        this$0.columnsStore.put(tx, NameBinding.Column.INSTANCE.toEntry($name), (ByteIterable)ColumnStatistic.Companion.objectToEntry($statistic));
    }

    private static final void deleteColumnStatistic$lambda$7(StatisticsStorageManager this$0, Name.ColumnName $column, Transaction tx) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$column, (String)"$column");
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        this$0.columnsStore.delete(tx, NameBinding.Column.INSTANCE.toEntry($column));
    }
}

