/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.statistics.values;

import java.io.ByteArrayInputStream;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.util.LightOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.values.Complex64VectorValue;
import org.vitrivr.cottontail.dbms.statistics.values.AbstractVectorStatistics;
import org.vitrivr.cottontail.storage.serializers.statistics.MetricsXodusBinding;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001$B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0006B+\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\f\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0018\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\nH\u00c6\u0003J\t\u0010\u001a\u001a\u00020\nH\u00c6\u0003J\t\u0010\u001b\u001a\u00020\nH\u00c6\u0003J1\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u00d6\u0003J\t\u0010!\u001a\u00020\bH\u00d6\u0001J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\f\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u000b\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0011\"\u0004\b\u0015\u0010\u0013R\u001a\u0010\t\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0011\"\u0004\b\u0017\u0010\u0013\u00a8\u0006%"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/values/Complex64VectorValueStatistics;", "Lorg/vitrivr/cottontail/dbms/statistics/values/AbstractVectorStatistics;", "Lorg/vitrivr/cottontail/core/values/Complex64VectorValue;", "factor", "", "metrics", "(FLorg/vitrivr/cottontail/dbms/statistics/values/Complex64VectorValueStatistics;)V", "logicalSize", "", "numberOfNullEntries", "", "numberOfNonNullEntries", "numberOfDistinctEntries", "(IJJJ)V", "getLogicalSize", "()I", "getNumberOfDistinctEntries", "()J", "setNumberOfDistinctEntries", "(J)V", "getNumberOfNonNullEntries", "setNumberOfNonNullEntries", "getNumberOfNullEntries", "setNumberOfNullEntries", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "toString", "", "Binding", "cottontaildb-dbms"})
public final class Complex64VectorValueStatistics
extends AbstractVectorStatistics<Complex64VectorValue> {
    private final int logicalSize;
    private long numberOfNullEntries;
    private long numberOfNonNullEntries;
    private long numberOfDistinctEntries;

    public Complex64VectorValueStatistics(int logicalSize, long numberOfNullEntries, long numberOfNonNullEntries, long numberOfDistinctEntries) {
        super((Types)new Types.Complex64Vector(logicalSize), null);
        this.logicalSize = logicalSize;
        this.numberOfNullEntries = numberOfNullEntries;
        this.numberOfNonNullEntries = numberOfNonNullEntries;
        this.numberOfDistinctEntries = numberOfDistinctEntries;
    }

    public /* synthetic */ Complex64VectorValueStatistics(int n, long l, long l2, long l3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            l = 0L;
        }
        if ((n2 & 4) != 0) {
            l2 = 0L;
        }
        if ((n2 & 8) != 0) {
            l3 = 0L;
        }
        this(n, l, l2, l3);
    }

    public final int getLogicalSize() {
        return this.logicalSize;
    }

    @Override
    public long getNumberOfNullEntries() {
        return this.numberOfNullEntries;
    }

    @Override
    public void setNumberOfNullEntries(long l) {
        this.numberOfNullEntries = l;
    }

    @Override
    public long getNumberOfNonNullEntries() {
        return this.numberOfNonNullEntries;
    }

    @Override
    public void setNumberOfNonNullEntries(long l) {
        this.numberOfNonNullEntries = l;
    }

    @Override
    public long getNumberOfDistinctEntries() {
        return this.numberOfDistinctEntries;
    }

    @Override
    public void setNumberOfDistinctEntries(long l) {
        this.numberOfDistinctEntries = l;
    }

    public Complex64VectorValueStatistics(float factor, @NotNull Complex64VectorValueStatistics metrics) {
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        this(metrics.logicalSize, (long)((float)metrics.getNumberOfNullEntries() * factor), (long)((float)metrics.getNumberOfNonNullEntries() * factor), (double)metrics.getNumberOfDistinctEntries() / (double)metrics.getNumberOfEntries() >= (double)metrics.getDistinctEntriesScalingThreshold() ? (long)((float)metrics.getNumberOfDistinctEntries() * factor) : metrics.getNumberOfDistinctEntries());
    }

    public final int component1() {
        return this.logicalSize;
    }

    public final long component2() {
        return this.numberOfNullEntries;
    }

    public final long component3() {
        return this.numberOfNonNullEntries;
    }

    public final long component4() {
        return this.numberOfDistinctEntries;
    }

    @NotNull
    public final Complex64VectorValueStatistics copy(int logicalSize, long numberOfNullEntries, long numberOfNonNullEntries, long numberOfDistinctEntries) {
        return new Complex64VectorValueStatistics(logicalSize, numberOfNullEntries, numberOfNonNullEntries, numberOfDistinctEntries);
    }

    public static /* synthetic */ Complex64VectorValueStatistics copy$default(Complex64VectorValueStatistics complex64VectorValueStatistics, int n, long l, long l2, long l3, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = complex64VectorValueStatistics.logicalSize;
        }
        if ((n2 & 2) != 0) {
            l = complex64VectorValueStatistics.numberOfNullEntries;
        }
        if ((n2 & 4) != 0) {
            l2 = complex64VectorValueStatistics.numberOfNonNullEntries;
        }
        if ((n2 & 8) != 0) {
            l3 = complex64VectorValueStatistics.numberOfDistinctEntries;
        }
        return complex64VectorValueStatistics.copy(n, l, l2, l3);
    }

    @NotNull
    public String toString() {
        return "Complex64VectorValueStatistics(logicalSize=" + this.logicalSize + ", numberOfNullEntries=" + this.numberOfNullEntries + ", numberOfNonNullEntries=" + this.numberOfNonNullEntries + ", numberOfDistinctEntries=" + this.numberOfDistinctEntries + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.logicalSize);
        result = result * 31 + Long.hashCode(this.numberOfNullEntries);
        result = result * 31 + Long.hashCode(this.numberOfNonNullEntries);
        result = result * 31 + Long.hashCode(this.numberOfDistinctEntries);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Complex64VectorValueStatistics)) {
            return false;
        }
        Complex64VectorValueStatistics complex64VectorValueStatistics = (Complex64VectorValueStatistics)other;
        if (this.logicalSize != complex64VectorValueStatistics.logicalSize) {
            return false;
        }
        if (this.numberOfNullEntries != complex64VectorValueStatistics.numberOfNullEntries) {
            return false;
        }
        if (this.numberOfNonNullEntries != complex64VectorValueStatistics.numberOfNonNullEntries) {
            return false;
        }
        return this.numberOfDistinctEntries == complex64VectorValueStatistics.numberOfDistinctEntries;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/values/Complex64VectorValueStatistics$Binding;", "Lorg/vitrivr/cottontail/storage/serializers/statistics/MetricsXodusBinding;", "Lorg/vitrivr/cottontail/dbms/statistics/values/Complex64VectorValueStatistics;", "logicalSize", "", "(I)V", "getLogicalSize", "()I", "read", "stream", "Ljava/io/ByteArrayInputStream;", "write", "", "output", "Ljetbrains/exodus/util/LightOutputStream;", "statistics", "cottontaildb-dbms"})
    public static final class Binding
    implements MetricsXodusBinding<Complex64VectorValueStatistics> {
        private final int logicalSize;

        public Binding(int logicalSize) {
            this.logicalSize = logicalSize;
        }

        public final int getLogicalSize() {
            return this.logicalSize;
        }

        @Override
        @NotNull
        public Complex64VectorValueStatistics read(@NotNull ByteArrayInputStream stream) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            long numberOfNullEntries = LongBinding.readCompressed((ByteArrayInputStream)stream);
            long numberOfNonNullEntries = LongBinding.readCompressed((ByteArrayInputStream)stream);
            long numberOfDistinctEntries = LongBinding.readCompressed((ByteArrayInputStream)stream);
            return new Complex64VectorValueStatistics(this.logicalSize, numberOfNullEntries, numberOfNonNullEntries, numberOfDistinctEntries);
        }

        @Override
        public void write(@NotNull LightOutputStream output, @NotNull Complex64VectorValueStatistics statistics2) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter((Object)statistics2, (String)"statistics");
            LongBinding.writeCompressed((LightOutputStream)output, (long)statistics2.getNumberOfNullEntries());
            LongBinding.writeCompressed((LightOutputStream)output, (long)statistics2.getNumberOfNonNullEntries());
            LongBinding.writeCompressed((LightOutputStream)output, (long)statistics2.getNumberOfDistinctEntries());
        }
    }
}

