/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.server.grpc.services;

import io.grpc.StatusException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.time.ExperimentalTime;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.client.language.extensions.NameExtensionsKt;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.queries.sort.SortOrder;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.dbms.catalogue.DefaultCatalogue;
import org.vitrivr.cottontail.dbms.column.ColumnMetadata;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.exceptions.QueryException;
import org.vitrivr.cottontail.dbms.execution.operators.basics.Operator;
import org.vitrivr.cottontail.dbms.execution.services.AutoRebuilderService;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionManager;
import org.vitrivr.cottontail.dbms.index.basic.IndexType;
import org.vitrivr.cottontail.dbms.queries.context.DefaultQueryContext;
import org.vitrivr.cottontail.dbms.queries.operators.physical.definition.AboutEntityPhysicalOperatorNode;
import org.vitrivr.cottontail.dbms.queries.operators.physical.definition.AboutIndexPhysicalOperatorNode;
import org.vitrivr.cottontail.dbms.queries.operators.physical.definition.AnalyseEntityPhysicalOperatorNode;
import org.vitrivr.cottontail.dbms.queries.operators.physical.definition.CreateEntityPhysicalOperatorNode;
import org.vitrivr.cottontail.dbms.queries.operators.physical.definition.CreateIndexPhysicalOperatorNode;
import org.vitrivr.cottontail.dbms.queries.operators.physical.definition.CreateSchemaPhysicalOperatorNode;
import org.vitrivr.cottontail.dbms.queries.operators.physical.definition.DropEntityPhysicalOperatorNode;
import org.vitrivr.cottontail.dbms.queries.operators.physical.definition.DropIndexPhysicalOperatorNode;
import org.vitrivr.cottontail.dbms.queries.operators.physical.definition.DropSchemaPhysicalOperatorNode;
import org.vitrivr.cottontail.dbms.queries.operators.physical.definition.EntityStatisticsPhysicalOperatorNode;
import org.vitrivr.cottontail.dbms.queries.operators.physical.definition.ListEntityPhysicalOperatorNode;
import org.vitrivr.cottontail.dbms.queries.operators.physical.definition.ListSchemaPhysicalOperatorNode;
import org.vitrivr.cottontail.dbms.queries.operators.physical.definition.RebuildIndexPhysicalOperatorNode;
import org.vitrivr.cottontail.dbms.queries.operators.physical.definition.TruncateEntityPhysicalOperatorNode;
import org.vitrivr.cottontail.dbms.queries.operators.physical.sort.InMemorySortPhysicalOperatorNode;
import org.vitrivr.cottontail.grpc.CottontailGrpc;
import org.vitrivr.cottontail.grpc.DDLGrpcKt;
import org.vitrivr.cottontail.server.grpc.services.DDLService;
import org.vitrivr.cottontail.server.grpc.services.TransactionalGrpcService;
import org.vitrivr.cottontail.storage.serializers.tablets.Compression;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0012H\u0096@\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0015H\u0096@\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0018H\u0096@\u00a2\u0006\u0002\u0010\u0019J\u0016\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u001bH\u0096@\u00a2\u0006\u0002\u0010\u001cJ\u0016\u0010\u001d\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u001eH\u0096@\u00a2\u0006\u0002\u0010\u001fJ\u0016\u0010 \u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020!H\u0096@\u00a2\u0006\u0002\u0010\"J\u0016\u0010#\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020$H\u0096@\u00a2\u0006\u0002\u0010%J\u0016\u0010&\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020$H\u0096@\u00a2\u0006\u0002\u0010%J\u0016\u0010'\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020(H\u0096@\u00a2\u0006\u0002\u0010)J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\r0+2\u0006\u0010\u000e\u001a\u00020,H\u0016J\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020\r0+2\u0006\u0010\u000e\u001a\u00020.H\u0016J\u0016\u0010/\u001a\u00020\r2\u0006\u0010\u000e\u001a\u000200H\u0096@\u00a2\u0006\u0002\u00101J\u0016\u00102\u001a\u00020\r2\u0006\u0010\u000e\u001a\u000203H\u0096@\u00a2\u0006\u0002\u00104R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u00065"}, d2={"Lorg/vitrivr/cottontail/server/grpc/services/DDLService;", "Lorg/vitrivr/cottontail/grpc/DDLGrpcKt$DDLCoroutineImplBase;", "Lorg/vitrivr/cottontail/server/grpc/services/TransactionalGrpcService;", "catalogue", "Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "autoRebuilderService", "Lorg/vitrivr/cottontail/dbms/execution/services/AutoRebuilderService;", "(Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;Lorg/vitrivr/cottontail/dbms/execution/services/AutoRebuilderService;)V", "getAutoRebuilderService", "()Lorg/vitrivr/cottontail/dbms/execution/services/AutoRebuilderService;", "getCatalogue", "()Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "analyzeEntity", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$QueryResponseMessage;", "request", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$AnalyzeEntityMessage;", "(Lorg/vitrivr/cottontail/grpc/CottontailGrpc$AnalyzeEntityMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createEntity", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$CreateEntityMessage;", "(Lorg/vitrivr/cottontail/grpc/CottontailGrpc$CreateEntityMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createIndex", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$CreateIndexMessage;", "(Lorg/vitrivr/cottontail/grpc/CottontailGrpc$CreateIndexMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createSchema", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$CreateSchemaMessage;", "(Lorg/vitrivr/cottontail/grpc/CottontailGrpc$CreateSchemaMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dropEntity", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$DropEntityMessage;", "(Lorg/vitrivr/cottontail/grpc/CottontailGrpc$DropEntityMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dropIndex", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$DropIndexMessage;", "(Lorg/vitrivr/cottontail/grpc/CottontailGrpc$DropIndexMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dropSchema", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$DropSchemaMessage;", "(Lorg/vitrivr/cottontail/grpc/CottontailGrpc$DropSchemaMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "entityDetails", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$EntityDetailsMessage;", "(Lorg/vitrivr/cottontail/grpc/CottontailGrpc$EntityDetailsMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "entityStatistics", "indexDetails", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$IndexDetailsMessage;", "(Lorg/vitrivr/cottontail/grpc/CottontailGrpc$IndexDetailsMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "listEntities", "Lkotlinx/coroutines/flow/Flow;", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$ListEntityMessage;", "listSchemas", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$ListSchemaMessage;", "rebuildIndex", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$RebuildIndexMessage;", "(Lorg/vitrivr/cottontail/grpc/CottontailGrpc$RebuildIndexMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "truncateEntity", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$TruncateEntityMessage;", "(Lorg/vitrivr/cottontail/grpc/CottontailGrpc$TruncateEntityMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "cottontaildb-dbms"})
@ExperimentalTime
public final class DDLService
extends DDLGrpcKt.DDLCoroutineImplBase
implements TransactionalGrpcService {
    @NotNull
    private final DefaultCatalogue catalogue;
    @NotNull
    private final AutoRebuilderService autoRebuilderService;

    public DDLService(@NotNull DefaultCatalogue catalogue, @NotNull AutoRebuilderService autoRebuilderService) {
        Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
        Intrinsics.checkNotNullParameter((Object)autoRebuilderService, (String)"autoRebuilderService");
        super(null, 1, null);
        this.catalogue = catalogue;
        this.autoRebuilderService = autoRebuilderService;
    }

    @Override
    @NotNull
    public DefaultCatalogue getCatalogue() {
        return this.catalogue;
    }

    @NotNull
    public final AutoRebuilderService getAutoRebuilderService() {
        return this.autoRebuilderService;
    }

    @Nullable
    public Object createSchema(@NotNull CottontailGrpc.CreateSchemaMessage request, @NotNull Continuation<? super CottontailGrpc.QueryResponseMessage> $completion) {
        CottontailGrpc.RequestMetadata requestMetadata = request.getMetadata();
        Intrinsics.checkNotNullExpressionValue((Object)requestMetadata, (String)"getMetadata(...)");
        return FlowKt.single(this.prepareAndExecute(requestMetadata, false, (Function1<? super DefaultQueryContext, ? extends Operator>)((Function1)new Function1<DefaultQueryContext, Operator>(request, this){
            final /* synthetic */ CottontailGrpc.CreateSchemaMessage $request;
            final /* synthetic */ DDLService this$0;
            {
                this.$request = $request;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Operator invoke(@NotNull DefaultQueryContext ctx) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                CottontailGrpc.SchemaName schemaName = this.$request.getSchema();
                Intrinsics.checkNotNullExpressionValue((Object)schemaName, (String)"getSchema(...)");
                Name.SchemaName schemaName2 = NameExtensionsKt.parse((CottontailGrpc.SchemaName)schemaName);
                ctx.register(new CreateSchemaPhysicalOperatorNode(this.this$0.getCatalogue().newTx(ctx), schemaName2, this.$request.getMayExist(), ctx));
                return ctx.toOperatorTree();
            }
        })), $completion);
    }

    @Nullable
    public Object dropSchema(@NotNull CottontailGrpc.DropSchemaMessage request, @NotNull Continuation<? super CottontailGrpc.QueryResponseMessage> $completion) {
        CottontailGrpc.RequestMetadata requestMetadata = request.getMetadata();
        Intrinsics.checkNotNullExpressionValue((Object)requestMetadata, (String)"getMetadata(...)");
        return FlowKt.single(this.prepareAndExecute(requestMetadata, false, (Function1<? super DefaultQueryContext, ? extends Operator>)((Function1)new Function1<DefaultQueryContext, Operator>(request, this){
            final /* synthetic */ CottontailGrpc.DropSchemaMessage $request;
            final /* synthetic */ DDLService this$0;
            {
                this.$request = $request;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Operator invoke(@NotNull DefaultQueryContext ctx) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                CottontailGrpc.SchemaName schemaName = this.$request.getSchema();
                Intrinsics.checkNotNullExpressionValue((Object)schemaName, (String)"getSchema(...)");
                Name.SchemaName schemaName2 = NameExtensionsKt.parse((CottontailGrpc.SchemaName)schemaName);
                ctx.register(new DropSchemaPhysicalOperatorNode(this.this$0.getCatalogue().newTx(ctx), schemaName2, ctx));
                return ctx.toOperatorTree();
            }
        })), $completion);
    }

    @NotNull
    public Flow<CottontailGrpc.QueryResponseMessage> listSchemas(@NotNull CottontailGrpc.ListSchemaMessage request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        CottontailGrpc.RequestMetadata requestMetadata = request.getMetadata();
        Intrinsics.checkNotNullExpressionValue((Object)requestMetadata, (String)"getMetadata(...)");
        return this.prepareAndExecute(requestMetadata, true, (Function1<? super DefaultQueryContext, ? extends Operator>)((Function1)new Function1<DefaultQueryContext, Operator>(this){
            final /* synthetic */ DDLService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Operator invoke(@NotNull DefaultQueryContext ctx) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                ListSchemaPhysicalOperatorNode list = new ListSchemaPhysicalOperatorNode(this.this$0.getCatalogue().newTx(ctx), ctx);
                ctx.register(new InMemorySortPhysicalOperatorNode(list, CollectionsKt.listOf((Object)TuplesKt.to((Object)CollectionsKt.first(list.getColumns()), (Object)SortOrder.ASCENDING))));
                return ctx.toOperatorTree();
            }
        }));
    }

    @Nullable
    public Object createEntity(@NotNull CottontailGrpc.CreateEntityMessage request, @NotNull Continuation<? super CottontailGrpc.QueryResponseMessage> $completion) {
        CottontailGrpc.RequestMetadata requestMetadata = request.getMetadata();
        Intrinsics.checkNotNullExpressionValue((Object)requestMetadata, (String)"getMetadata(...)");
        return FlowKt.single(this.prepareAndExecute(requestMetadata, false, (Function1<? super DefaultQueryContext, ? extends Operator>)((Function1)new Function1<DefaultQueryContext, Operator>(request, this){
            final /* synthetic */ CottontailGrpc.CreateEntityMessage $request;
            final /* synthetic */ DDLService this$0;
            {
                this.$request = $request;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Operator invoke(@NotNull DefaultQueryContext ctx) {
                Operator operator;
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                CottontailGrpc.EntityName entityName = this.$request.getEntity();
                Intrinsics.checkNotNullExpressionValue((Object)entityName, (String)"getEntity(...)");
                Name.EntityName entityName2 = NameExtensionsKt.parse((CottontailGrpc.EntityName)entityName);
                try {
                    void $this$mapTo$iv$iv;
                    List list = this.$request.getColumnsList();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getColumnsList(...)");
                    Iterable $this$map$iv = list;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        Compression compression;
                        void it;
                        CottontailGrpc.ColumnDefinition columnDefinition = (CottontailGrpc.ColumnDefinition)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        Types type = Types.Companion.forName(it.getType().name(), it.getLength());
                        String string = it.getName().getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        Name.ColumnName name = entityName2.column(string);
                        CottontailGrpc.ColumnDefinition.Compression compression2 = it.getCompression();
                        switch (compression2 == null ? -1 : createEntity.WhenMappings.$EnumSwitchMapping$0[compression2.ordinal()]) {
                            case 1: {
                                compression = Compression.SNAPPY;
                                break;
                            }
                            case 2: {
                                compression = Compression.LZ4;
                                break;
                            }
                            default: {
                                compression = Compression.NONE;
                            }
                        }
                        Compression compression3 = compression;
                        collection.add(TuplesKt.to((Object)name, (Object)new ColumnMetadata(type, compression3, it.getNullable(), it.getPrimary(), it.getAutoIncrement())));
                    }
                    List columns2 = (List)destination$iv$iv;
                    ctx.register(new CreateEntityPhysicalOperatorNode(this.this$0.getCatalogue().newTx(ctx), entityName2, this.$request.getMayExist(), columns2, ctx));
                    operator = ctx.toOperatorTree();
                }
                catch (IllegalArgumentException e) {
                    throw new DatabaseException.ValidationException("Invalid entity definition: " + e.getMessage());
                }
                return operator;
            }
        })), $completion);
    }

    @Nullable
    public Object dropEntity(@NotNull CottontailGrpc.DropEntityMessage request, @NotNull Continuation<? super CottontailGrpc.QueryResponseMessage> $completion) {
        CottontailGrpc.RequestMetadata requestMetadata = request.getMetadata();
        Intrinsics.checkNotNullExpressionValue((Object)requestMetadata, (String)"getMetadata(...)");
        return FlowKt.single(this.prepareAndExecute(requestMetadata, false, (Function1<? super DefaultQueryContext, ? extends Operator>)((Function1)new Function1<DefaultQueryContext, Operator>(request, this){
            final /* synthetic */ CottontailGrpc.DropEntityMessage $request;
            final /* synthetic */ DDLService this$0;
            {
                this.$request = $request;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Operator invoke(@NotNull DefaultQueryContext ctx) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                CottontailGrpc.EntityName entityName = this.$request.getEntity();
                Intrinsics.checkNotNullExpressionValue((Object)entityName, (String)"getEntity(...)");
                Name.EntityName entityName2 = NameExtensionsKt.parse((CottontailGrpc.EntityName)entityName);
                ctx.register(new DropEntityPhysicalOperatorNode(this.this$0.getCatalogue().newTx(ctx), entityName2, ctx));
                return ctx.toOperatorTree();
            }
        })), $completion);
    }

    @Nullable
    public Object truncateEntity(@NotNull CottontailGrpc.TruncateEntityMessage request, @NotNull Continuation<? super CottontailGrpc.QueryResponseMessage> $completion) {
        CottontailGrpc.RequestMetadata requestMetadata = request.getMetadata();
        Intrinsics.checkNotNullExpressionValue((Object)requestMetadata, (String)"getMetadata(...)");
        return FlowKt.single(this.prepareAndExecute(requestMetadata, false, (Function1<? super DefaultQueryContext, ? extends Operator>)((Function1)new Function1<DefaultQueryContext, Operator>(request, this){
            final /* synthetic */ CottontailGrpc.TruncateEntityMessage $request;
            final /* synthetic */ DDLService this$0;
            {
                this.$request = $request;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Operator invoke(@NotNull DefaultQueryContext ctx) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                CottontailGrpc.EntityName entityName = this.$request.getEntity();
                Intrinsics.checkNotNullExpressionValue((Object)entityName, (String)"getEntity(...)");
                Name.EntityName entityName2 = NameExtensionsKt.parse((CottontailGrpc.EntityName)entityName);
                ctx.register(new TruncateEntityPhysicalOperatorNode(this.this$0.getCatalogue().newTx(ctx), entityName2, ctx));
                return ctx.toOperatorTree();
            }
        })), $completion);
    }

    @Nullable
    public Object analyzeEntity(@NotNull CottontailGrpc.AnalyzeEntityMessage request, @NotNull Continuation<? super CottontailGrpc.QueryResponseMessage> $completion) {
        CottontailGrpc.RequestMetadata requestMetadata = request.getMetadata();
        Intrinsics.checkNotNullExpressionValue((Object)requestMetadata, (String)"getMetadata(...)");
        return FlowKt.single(this.prepareAndExecute(requestMetadata, false, (Function1<? super DefaultQueryContext, ? extends Operator>)((Function1)new Function1<DefaultQueryContext, Operator>(request, this){
            final /* synthetic */ CottontailGrpc.AnalyzeEntityMessage $request;
            final /* synthetic */ DDLService this$0;
            {
                this.$request = $request;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Operator invoke(@NotNull DefaultQueryContext ctx) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                CottontailGrpc.EntityName entityName = this.$request.getEntity();
                Intrinsics.checkNotNullExpressionValue((Object)entityName, (String)"getEntity(...)");
                Name.EntityName entityName2 = NameExtensionsKt.parse((CottontailGrpc.EntityName)entityName);
                ctx.register(new AnalyseEntityPhysicalOperatorNode(this.this$0.getCatalogue().newTx(ctx), entityName2, ctx));
                return ctx.toOperatorTree();
            }
        })), $completion);
    }

    @NotNull
    public Flow<CottontailGrpc.QueryResponseMessage> listEntities(@NotNull CottontailGrpc.ListEntityMessage request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        CottontailGrpc.RequestMetadata requestMetadata = request.getMetadata();
        Intrinsics.checkNotNullExpressionValue((Object)requestMetadata, (String)"getMetadata(...)");
        return this.prepareAndExecute(requestMetadata, true, (Function1<? super DefaultQueryContext, ? extends Operator>)((Function1)new Function1<DefaultQueryContext, Operator>(request, this){
            final /* synthetic */ CottontailGrpc.ListEntityMessage $request;
            final /* synthetic */ DDLService this$0;
            {
                this.$request = $request;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Operator invoke(@NotNull DefaultQueryContext ctx) {
                Name.SchemaName schemaName;
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                if (this.$request.hasSchema()) {
                    CottontailGrpc.SchemaName schemaName2 = this.$request.getSchema();
                    Intrinsics.checkNotNullExpressionValue((Object)schemaName2, (String)"getSchema(...)");
                    schemaName = NameExtensionsKt.parse((CottontailGrpc.SchemaName)schemaName2);
                } else {
                    schemaName = null;
                }
                Name.SchemaName schemaName3 = schemaName;
                ListEntityPhysicalOperatorNode list = new ListEntityPhysicalOperatorNode(this.this$0.getCatalogue().newTx(ctx), schemaName3, ctx);
                ctx.register(new InMemorySortPhysicalOperatorNode(list, CollectionsKt.listOf((Object)TuplesKt.to((Object)CollectionsKt.first(list.getColumns()), (Object)SortOrder.ASCENDING))));
                return ctx.toOperatorTree();
            }
        }));
    }

    @Nullable
    public Object entityDetails(@NotNull CottontailGrpc.EntityDetailsMessage request, @NotNull Continuation<? super CottontailGrpc.QueryResponseMessage> $completion) {
        CottontailGrpc.RequestMetadata requestMetadata = request.getMetadata();
        Intrinsics.checkNotNullExpressionValue((Object)requestMetadata, (String)"getMetadata(...)");
        return FlowKt.single(this.prepareAndExecute(requestMetadata, true, (Function1<? super DefaultQueryContext, ? extends Operator>)((Function1)new Function1<DefaultQueryContext, Operator>(request, this){
            final /* synthetic */ CottontailGrpc.EntityDetailsMessage $request;
            final /* synthetic */ DDLService this$0;
            {
                this.$request = $request;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Operator invoke(@NotNull DefaultQueryContext ctx) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                CottontailGrpc.EntityName entityName = this.$request.getEntity();
                Intrinsics.checkNotNullExpressionValue((Object)entityName, (String)"getEntity(...)");
                Name.EntityName entityName2 = NameExtensionsKt.parse((CottontailGrpc.EntityName)entityName);
                ctx.register(new AboutEntityPhysicalOperatorNode(this.this$0.getCatalogue().newTx(ctx), entityName2, ctx));
                return ctx.toOperatorTree();
            }
        })), $completion);
    }

    @Nullable
    public Object entityStatistics(@NotNull CottontailGrpc.EntityDetailsMessage request, @NotNull Continuation<? super CottontailGrpc.QueryResponseMessage> $completion) {
        CottontailGrpc.RequestMetadata requestMetadata = request.getMetadata();
        Intrinsics.checkNotNullExpressionValue((Object)requestMetadata, (String)"getMetadata(...)");
        return FlowKt.single(this.prepareAndExecute(requestMetadata, true, (Function1<? super DefaultQueryContext, ? extends Operator>)((Function1)new Function1<DefaultQueryContext, Operator>(request, this){
            final /* synthetic */ CottontailGrpc.EntityDetailsMessage $request;
            final /* synthetic */ DDLService this$0;
            {
                this.$request = $request;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Operator invoke(@NotNull DefaultQueryContext ctx) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                CottontailGrpc.EntityName entityName = this.$request.getEntity();
                Intrinsics.checkNotNullExpressionValue((Object)entityName, (String)"getEntity(...)");
                Name.EntityName entityName2 = NameExtensionsKt.parse((CottontailGrpc.EntityName)entityName);
                ctx.register(new EntityStatisticsPhysicalOperatorNode(this.this$0.getCatalogue().newTx(ctx), entityName2, ctx));
                return ctx.toOperatorTree();
            }
        })), $completion);
    }

    @Nullable
    public Object createIndex(@NotNull CottontailGrpc.CreateIndexMessage request, @NotNull Continuation<? super CottontailGrpc.QueryResponseMessage> $completion) {
        CottontailGrpc.RequestMetadata requestMetadata = request.getMetadata();
        Intrinsics.checkNotNullExpressionValue((Object)requestMetadata, (String)"getMetadata(...)");
        return FlowKt.single(this.prepareAndExecute(requestMetadata, false, (Function1<? super DefaultQueryContext, ? extends Operator>)((Function1)new Function1<DefaultQueryContext, Operator>(request, this){
            final /* synthetic */ CottontailGrpc.CreateIndexMessage $request;
            final /* synthetic */ DDLService this$0;
            {
                this.$request = $request;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * Unable to fully structure code
             */
            @NotNull
            public final Operator invoke(@NotNull DefaultQueryContext ctx) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                v0 = this.$request.getEntity();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getEntity(...)");
                entityName = NameExtensionsKt.parse((CottontailGrpc.EntityName)v0);
                v1 = this.$request.getColumnsList();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getColumnsList(...)");
                $this$map$iv = (Iterable)v1;
                $i$f$map = false;
                var6_6 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var11_11 = (String)item$iv$iv;
                    var13_13 = destination$iv$iv;
                    $i$a$-map-DDLService$createIndex$2$columns$1 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (StringsKt.contains$default((CharSequence)((CharSequence)it), (char)'.', (boolean)false, (int)2, null)) {
                        throw new QueryException.QuerySyntaxException("Column name '" + (String)it + "' must not contain dots for CREATE INDEX command.");
                    }
                    var13_13.add(entityName.column((String)it));
                }
                columns = (List)destination$iv$iv;
                indexType = IndexType.valueOf(this.$request.getType().toString());
                params = this.$request.getParamsMap();
                if (this.$request.getIndexName() == null) ** GOTO lbl-1000
                v2 = this.$request.getIndexName();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getIndexName(...)");
                if (((CharSequence)v2).length() > 0) {
                    v3 = this.$request.getIndexName();
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getIndexName(...)");
                    if (StringsKt.contains$default((CharSequence)v3, (char)'.', (boolean)false, (int)2, null)) {
                        throw new QueryException.QuerySyntaxException("Index name '" + this.$request.getIndexName() + "' must not contain dots for CREATE INDEX command.");
                    }
                    v4 = this.$request.getIndexName();
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getIndexName(...)");
                    v5 = entityName.index(v4);
                } else lbl-1000:
                // 2 sources

                {
                    v6 = this.$request.getColumnsList();
                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getColumnsList(...)");
                    v7 = CollectionsKt.joinToString$default((Iterable)((Iterable)v6), (CharSequence)"-", null, null, (int)0, null, null, (int)62, null);
                    v8 = indexType.name().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"toLowerCase(...)");
                    v5 = entityName.index("idx_" + v7 + "_" + v8);
                }
                indexName = v5;
                v9 = this.this$0.getCatalogue().newTx(ctx);
                Intrinsics.checkNotNull((Object)params);
                ctx.register(new CreateIndexPhysicalOperatorNode(v9, indexName, indexType, columns, params, ctx));
                return ctx.toOperatorTree();
            }
        })), $completion);
    }

    @Nullable
    public Object dropIndex(@NotNull CottontailGrpc.DropIndexMessage request, @NotNull Continuation<? super CottontailGrpc.QueryResponseMessage> $completion) {
        CottontailGrpc.RequestMetadata requestMetadata = request.getMetadata();
        Intrinsics.checkNotNullExpressionValue((Object)requestMetadata, (String)"getMetadata(...)");
        return FlowKt.single(this.prepareAndExecute(requestMetadata, false, (Function1<? super DefaultQueryContext, ? extends Operator>)((Function1)new Function1<DefaultQueryContext, Operator>(request, this){
            final /* synthetic */ CottontailGrpc.DropIndexMessage $request;
            final /* synthetic */ DDLService this$0;
            {
                this.$request = $request;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Operator invoke(@NotNull DefaultQueryContext ctx) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                CottontailGrpc.IndexName indexName = this.$request.getIndex();
                Intrinsics.checkNotNullExpressionValue((Object)indexName, (String)"getIndex(...)");
                Name.IndexName indexName2 = NameExtensionsKt.parse((CottontailGrpc.IndexName)indexName);
                ctx.register(new DropIndexPhysicalOperatorNode(this.this$0.getCatalogue().newTx(ctx), indexName2, ctx));
                return ctx.toOperatorTree();
            }
        })), $completion);
    }

    @Nullable
    public Object indexDetails(@NotNull CottontailGrpc.IndexDetailsMessage request, @NotNull Continuation<? super CottontailGrpc.QueryResponseMessage> $completion) {
        CottontailGrpc.RequestMetadata requestMetadata = request.getMetadata();
        Intrinsics.checkNotNullExpressionValue((Object)requestMetadata, (String)"getMetadata(...)");
        return FlowKt.single(this.prepareAndExecute(requestMetadata, true, (Function1<? super DefaultQueryContext, ? extends Operator>)((Function1)new Function1<DefaultQueryContext, Operator>(request, this){
            final /* synthetic */ CottontailGrpc.IndexDetailsMessage $request;
            final /* synthetic */ DDLService this$0;
            {
                this.$request = $request;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Operator invoke(@NotNull DefaultQueryContext ctx) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                CottontailGrpc.IndexName indexName = this.$request.getIndex();
                Intrinsics.checkNotNullExpressionValue((Object)indexName, (String)"getIndex(...)");
                Name.IndexName indexName2 = NameExtensionsKt.parse((CottontailGrpc.IndexName)indexName);
                ctx.register(new AboutIndexPhysicalOperatorNode(this.this$0.getCatalogue().newTx(ctx), indexName2, ctx));
                return ctx.toOperatorTree();
            }
        })), $completion);
    }

    @Nullable
    public Object rebuildIndex(@NotNull CottontailGrpc.RebuildIndexMessage request, @NotNull Continuation<? super CottontailGrpc.QueryResponseMessage> $completion) {
        CottontailGrpc.RequestMetadata requestMetadata = request.getMetadata();
        Intrinsics.checkNotNullExpressionValue((Object)requestMetadata, (String)"getMetadata(...)");
        return FlowKt.single(this.prepareAndExecute(requestMetadata, false, (Function1<? super DefaultQueryContext, ? extends Operator>)((Function1)new Function1<DefaultQueryContext, Operator>(request, this){
            final /* synthetic */ CottontailGrpc.RebuildIndexMessage $request;
            final /* synthetic */ DDLService this$0;
            {
                this.$request = $request;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Operator invoke(@NotNull DefaultQueryContext ctx) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                CottontailGrpc.IndexName indexName = this.$request.getIndex();
                Intrinsics.checkNotNullExpressionValue((Object)indexName, (String)"getIndex(...)");
                Name.IndexName indexName2 = NameExtensionsKt.parse((CottontailGrpc.IndexName)indexName);
                if (this.$request.getAsync()) {
                    ctx.register(new RebuildIndexPhysicalOperatorNode(this.this$0.getCatalogue().newTx(ctx), indexName2, this.this$0.getAutoRebuilderService(), ctx));
                } else {
                    ctx.register(new RebuildIndexPhysicalOperatorNode(this.this$0.getCatalogue().newTx(ctx), indexName2, null, ctx));
                }
                return ctx.toOperatorTree();
            }
        })), $completion);
    }

    @Override
    @NotNull
    public TransactionManager getManager() {
        return TransactionalGrpcService.DefaultImpls.getManager(this);
    }

    @Override
    @NotNull
    public DefaultQueryContext queryContextFromMetadata(@NotNull CottontailGrpc.RequestMetadata metadata, boolean readOnly) {
        return TransactionalGrpcService.DefaultImpls.queryContextFromMetadata(this, metadata, readOnly);
    }

    @Override
    @NotNull
    public Flow<CottontailGrpc.QueryResponseMessage> prepareAndExecute(@NotNull CottontailGrpc.RequestMetadata metadata, boolean readOnly, @NotNull Function1<? super DefaultQueryContext, ? extends Operator> prepare) {
        return TransactionalGrpcService.DefaultImpls.prepareAndExecute(this, metadata, readOnly, prepare);
    }

    @Override
    @NotNull
    public StatusException handleError(@NotNull DefaultQueryContext $this$handleError, @NotNull Throwable e, boolean execution) {
        return TransactionalGrpcService.DefaultImpls.handleError(this, $this$handleError, e, execution);
    }
}

