/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.storage.serializers;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.types.Value;
import org.vitrivr.cottontail.dbms.statistics.values.BooleanValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.BooleanVectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.ByteStringValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.ByteValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.Complex32ValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.Complex32VectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.Complex64ValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.Complex64VectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.DateValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.DoubleValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.DoubleVectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.FloatValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.FloatVectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.IntValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.IntVectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.LongValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.LongVectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.ShortValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.ShortVectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.StringValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.UuidValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.ValueStatistics;
import org.vitrivr.cottontail.storage.serializers.statistics.MetricsXodusBinding;
import org.vitrivr.cottontail.storage.serializers.tablets.Compression;
import org.vitrivr.cottontail.storage.serializers.tablets.LZ4TabletSerializer;
import org.vitrivr.cottontail.storage.serializers.tablets.NoneTabletSerializer;
import org.vitrivr.cottontail.storage.serializers.tablets.SnappyTabletSerializer;
import org.vitrivr.cottontail.storage.serializers.tablets.TabletSerializer;
import org.vitrivr.cottontail.storage.serializers.values.BooleanValueValueSerializer;
import org.vitrivr.cottontail.storage.serializers.values.BooleanVectorValueValueSerializer;
import org.vitrivr.cottontail.storage.serializers.values.ByteStringValueValueSerializer;
import org.vitrivr.cottontail.storage.serializers.values.ByteValueValueSerializer;
import org.vitrivr.cottontail.storage.serializers.values.Complex32ValueValueSerializer;
import org.vitrivr.cottontail.storage.serializers.values.Complex32VectorValueValueSerializer;
import org.vitrivr.cottontail.storage.serializers.values.Complex64ValueValueSerializer;
import org.vitrivr.cottontail.storage.serializers.values.Complex64VectorValueValueSerializer;
import org.vitrivr.cottontail.storage.serializers.values.DateValueValueSerializer;
import org.vitrivr.cottontail.storage.serializers.values.DoubleValueValueSerializer;
import org.vitrivr.cottontail.storage.serializers.values.DoubleVectorValueValueSerializer;
import org.vitrivr.cottontail.storage.serializers.values.FloatValueValueSerializer;
import org.vitrivr.cottontail.storage.serializers.values.FloatVectorValueValueSerializer;
import org.vitrivr.cottontail.storage.serializers.values.HalfVectorValueValueSerializer;
import org.vitrivr.cottontail.storage.serializers.values.IntValueValueSerializer;
import org.vitrivr.cottontail.storage.serializers.values.IntVectorValueValueSerializer;
import org.vitrivr.cottontail.storage.serializers.values.LongValueValueSerializer;
import org.vitrivr.cottontail.storage.serializers.values.LongVectorValueValueSerializer;
import org.vitrivr.cottontail.storage.serializers.values.ShortValueValueSerializer;
import org.vitrivr.cottontail.storage.serializers.values.ShortVectorValueValueSerializer;
import org.vitrivr.cottontail.storage.serializers.values.StringValueValueSerializer;
import org.vitrivr.cottontail.storage.serializers.values.UuidValueSerializer;
import org.vitrivr.cottontail.storage.serializers.values.ValueSerializer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u00050\u0004\"\b\b\u0000\u0010\u0006*\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00060\tJ6\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000b\"\b\b\u0000\u0010\u0006*\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00060\t2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ$\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0011\"\b\b\u0000\u0010\u0006*\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00060\t\u00a8\u0006\u0012"}, d2={"Lorg/vitrivr/cottontail/storage/serializers/SerializerFactory;", "", "()V", "metrics", "Lorg/vitrivr/cottontail/storage/serializers/statistics/MetricsXodusBinding;", "Lorg/vitrivr/cottontail/dbms/statistics/values/ValueStatistics;", "T", "Lorg/vitrivr/cottontail/core/types/Value;", "type", "Lorg/vitrivr/cottontail/core/types/Types;", "tablet", "Lorg/vitrivr/cottontail/storage/serializers/tablets/TabletSerializer;", "size", "", "compression", "Lorg/vitrivr/cottontail/storage/serializers/tablets/Compression;", "value", "Lorg/vitrivr/cottontail/storage/serializers/values/ValueSerializer;", "cottontaildb-dbms"})
public final class SerializerFactory {
    @NotNull
    public static final SerializerFactory INSTANCE = new SerializerFactory();

    private SerializerFactory() {
    }

    @NotNull
    public final <T extends Value> MetricsXodusBinding<ValueStatistics<T>> metrics(@NotNull Types<T> type) {
        MetricsXodusBinding metricsXodusBinding;
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Types<T> types = type;
        if (Intrinsics.areEqual(types, (Object)Types.Boolean.INSTANCE)) {
            metricsXodusBinding = BooleanValueStatistics.Binding.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Date.INSTANCE)) {
            metricsXodusBinding = DateValueStatistics.Binding.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Byte.INSTANCE)) {
            metricsXodusBinding = ByteValueStatistics.Binding.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Complex32.INSTANCE)) {
            metricsXodusBinding = Complex32ValueStatistics.Binding.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Complex64.INSTANCE)) {
            metricsXodusBinding = Complex64ValueStatistics.Binding.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Double.INSTANCE)) {
            metricsXodusBinding = DoubleValueStatistics.Binding.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Float.INSTANCE)) {
            metricsXodusBinding = FloatValueStatistics.Binding.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Int.INSTANCE)) {
            metricsXodusBinding = IntValueStatistics.Binding.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Long.INSTANCE)) {
            metricsXodusBinding = LongValueStatistics.Binding.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Short.INSTANCE)) {
            metricsXodusBinding = ShortValueStatistics.Binding.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.String.INSTANCE)) {
            metricsXodusBinding = StringValueStatistics.Binding.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Uuid.INSTANCE)) {
            metricsXodusBinding = UuidValueStatistics.Binding.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.ByteString.INSTANCE)) {
            metricsXodusBinding = ByteStringValueStatistics.Binding.INSTANCE;
        } else if (types instanceof Types.BooleanVector) {
            metricsXodusBinding = new BooleanVectorValueStatistics.Binding(type.getLogicalSize());
        } else if (types instanceof Types.Complex32Vector) {
            metricsXodusBinding = new Complex32VectorValueStatistics.Binding(type.getLogicalSize());
        } else if (types instanceof Types.Complex64Vector) {
            metricsXodusBinding = new Complex64VectorValueStatistics.Binding(type.getLogicalSize());
        } else if (types instanceof Types.DoubleVector) {
            metricsXodusBinding = new DoubleVectorValueStatistics.Binding(type.getLogicalSize());
        } else if (types instanceof Types.HalfVector ? true : types instanceof Types.FloatVector) {
            metricsXodusBinding = new FloatVectorValueStatistics.Binding(type.getLogicalSize());
        } else if (types instanceof Types.IntVector) {
            metricsXodusBinding = new IntVectorValueStatistics.Binding(type.getLogicalSize());
        } else if (types instanceof Types.LongVector) {
            metricsXodusBinding = new LongVectorValueStatistics.Binding(type.getLogicalSize());
        } else if (types instanceof Types.ShortVector) {
            metricsXodusBinding = new ShortVectorValueStatistics.Binding(type.getLogicalSize());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        MetricsXodusBinding metricsXodusBinding2 = metricsXodusBinding;
        Intrinsics.checkNotNull((Object)metricsXodusBinding2, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.storage.serializers.statistics.MetricsXodusBinding<org.vitrivr.cottontail.dbms.statistics.values.ValueStatistics<T of org.vitrivr.cottontail.storage.serializers.SerializerFactory.metrics>>");
        return metricsXodusBinding2;
    }

    @NotNull
    public final <T extends Value> ValueSerializer<T> value(@NotNull Types<T> type) {
        ValueSerializer valueSerializer;
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Types<T> types = type;
        if (Intrinsics.areEqual(types, (Object)Types.Boolean.INSTANCE)) {
            valueSerializer = BooleanValueValueSerializer.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Date.INSTANCE)) {
            valueSerializer = DateValueValueSerializer.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Byte.INSTANCE)) {
            valueSerializer = ByteValueValueSerializer.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Complex32.INSTANCE)) {
            valueSerializer = Complex32ValueValueSerializer.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Complex64.INSTANCE)) {
            valueSerializer = Complex64ValueValueSerializer.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Double.INSTANCE)) {
            valueSerializer = DoubleValueValueSerializer.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Float.INSTANCE)) {
            valueSerializer = FloatValueValueSerializer.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Int.INSTANCE)) {
            valueSerializer = IntValueValueSerializer.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Long.INSTANCE)) {
            valueSerializer = LongValueValueSerializer.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Short.INSTANCE)) {
            valueSerializer = ShortValueValueSerializer.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.String.INSTANCE)) {
            valueSerializer = StringValueValueSerializer.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Uuid.INSTANCE)) {
            valueSerializer = UuidValueSerializer.INSTANCE;
        } else if (types instanceof Types.BooleanVector) {
            valueSerializer = new BooleanVectorValueValueSerializer(type.getLogicalSize());
        } else if (types instanceof Types.Complex32Vector) {
            valueSerializer = new Complex32VectorValueValueSerializer(type.getLogicalSize());
        } else if (types instanceof Types.Complex64Vector) {
            valueSerializer = new Complex64VectorValueValueSerializer(type.getLogicalSize());
        } else if (types instanceof Types.DoubleVector) {
            valueSerializer = new DoubleVectorValueValueSerializer(type.getLogicalSize());
        } else if (types instanceof Types.FloatVector) {
            valueSerializer = new FloatVectorValueValueSerializer(type.getLogicalSize());
        } else if (types instanceof Types.IntVector) {
            valueSerializer = new IntVectorValueValueSerializer(type.getLogicalSize());
        } else if (types instanceof Types.LongVector) {
            valueSerializer = new LongVectorValueValueSerializer(type.getLogicalSize());
        } else if (types instanceof Types.ByteString) {
            valueSerializer = ByteStringValueValueSerializer.INSTANCE;
        } else if (types instanceof Types.ShortVector) {
            valueSerializer = new ShortVectorValueValueSerializer(type.getLogicalSize());
        } else if (types instanceof Types.HalfVector) {
            valueSerializer = new HalfVectorValueValueSerializer(type.getLogicalSize());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        ValueSerializer valueSerializer2 = valueSerializer;
        Intrinsics.checkNotNull((Object)valueSerializer2, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.storage.serializers.values.ValueSerializer<T of org.vitrivr.cottontail.storage.serializers.SerializerFactory.value>");
        return valueSerializer2;
    }

    @NotNull
    public final <T extends Value> TabletSerializer<T> tablet(@NotNull Types<T> type, int size, @NotNull Compression compression) {
        TabletSerializer tabletSerializer;
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)compression), (String)"compression");
        switch (WhenMappings.$EnumSwitchMapping$0[compression.ordinal()]) {
            case 1: {
                tabletSerializer = new NoneTabletSerializer<T>(type, size);
                break;
            }
            case 2: {
                tabletSerializer = new LZ4TabletSerializer<T>(type, size);
                break;
            }
            case 3: {
                tabletSerializer = new SnappyTabletSerializer<T>(type, size);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return tabletSerializer;
    }

    public static /* synthetic */ TabletSerializer tablet$default(SerializerFactory serializerFactory, Types types, int n, Compression compression, int n2, Object object) {
        if ((n2 & 4) != 0) {
            compression = Compression.LZ4;
        }
        return serializerFactory.tablet(types, n, compression);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Compression.values().length];
            try {
                nArray[Compression.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Compression.LZ4.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Compression.SNAPPY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

