/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.storage.serializers.values;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.values.IntVectorValue;
import org.vitrivr.cottontail.storage.serializers.values.ValueSerializer;
import org.xerial.snappy.Snappy;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001d\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001a\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0002H\u0016\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0015"}, d2={"Lorg/vitrivr/cottontail/storage/serializers/values/IntVectorValueValueSerializer;", "Lorg/vitrivr/cottontail/storage/serializers/values/ValueSerializer;", "Lorg/vitrivr/cottontail/core/values/IntVectorValue;", "size", "", "(I)V", "getSize", "()I", "type", "Lorg/vitrivr/cottontail/core/types/Types;", "getType", "()Lorg/vitrivr/cottontail/core/types/Types;", "fromEntry", "entry", "Ljetbrains/exodus/ByteIterable;", "fromEntry-w3Tp6r4", "(Ljetbrains/exodus/ByteIterable;)[I", "toEntry", "value", "toEntry-_5GfI64", "([I)Ljetbrains/exodus/ByteIterable;", "cottontaildb-dbms"})
@SourceDebugExtension(value={"SMAP\nIntVectorValueValueSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntVectorValueValueSerializer.kt\norg/vitrivr/cottontail/storage/serializers/values/IntVectorValueValueSerializer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,27:1\n1#2:28\n*E\n"})
public final class IntVectorValueValueSerializer
implements ValueSerializer<IntVectorValue> {
    private final int size;
    @NotNull
    private final Types<IntVectorValue> type;

    public IntVectorValueValueSerializer(int size) {
        this.size = size;
        if (!(this.size > 0)) {
            boolean bl = false;
            String string = "Cannot initialize vector value binding with size value of " + this.size + ".";
            throw new IllegalArgumentException(string.toString());
        }
        this.type = (Types)new Types.IntVector(this.size);
    }

    public final int getSize() {
        return this.size;
    }

    @Override
    @NotNull
    public Types<IntVectorValue> getType() {
        return this.type;
    }

    @NotNull
    public int[] fromEntry-w3Tp6r4(@NotNull ByteIterable entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        int[] nArray = Snappy.uncompressIntArray((byte[])entry.getBytesUnsafe());
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"uncompressIntArray(...)");
        return IntVectorValue.constructor-impl((int[])nArray);
    }

    @NotNull
    public ByteIterable toEntry-_5GfI64(@NotNull int[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        byte[] compressed = Snappy.compress((int[])value);
        return (ByteIterable)new ArrayByteIterable(compressed, compressed.length);
    }
}

