/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.test;

import io.grpc.ManagedChannel;
import io.grpc.netty.NettyChannelBuilder;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.ExperimentalTime;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.client.SimpleClient;
import org.vitrivr.cottontail.test.EmbeddedCottontailGrpcServer;
import org.vitrivr.cottontail.test.GrpcTestUtils;
import org.vitrivr.cottontail.test.TestConstants;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000eJ\u0006\u0010\u0010\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/vitrivr/cottontail/test/AbstractClientTest;", "", "()V", "channel", "Lio/grpc/ManagedChannel;", "client", "Lorg/vitrivr/cottontail/client/SimpleClient;", "getClient", "()Lorg/vitrivr/cottontail/client/SimpleClient;", "setClient", "(Lorg/vitrivr/cottontail/client/SimpleClient;)V", "embedded", "Lorg/vitrivr/cottontail/test/EmbeddedCottontailGrpcServer;", "cleanAndConnect", "", "cleanup", "startAndPopulateCottontail", "cottontaildb-dbms_testFixtures"})
@ExperimentalTime
public abstract class AbstractClientTest {
    @NotNull
    private final EmbeddedCottontailGrpcServer embedded = new EmbeddedCottontailGrpcServer(TestConstants.INSTANCE.testConfig());
    @NotNull
    private final ManagedChannel channel;
    @NotNull
    private SimpleClient client;

    public AbstractClientTest() {
        ManagedChannel managedChannel = NettyChannelBuilder.forAddress((String)"localhost", (int)1865).usePlaintext().build();
        Intrinsics.checkNotNullExpressionValue((Object)managedChannel, (String)"build(...)");
        this.channel = managedChannel;
        this.client = new SimpleClient(this.channel);
    }

    @NotNull
    public final SimpleClient getClient() {
        return this.client;
    }

    public final void setClient(@NotNull SimpleClient simpleClient) {
        Intrinsics.checkNotNullParameter((Object)simpleClient, (String)"<set-?>");
        this.client = simpleClient;
    }

    public final void startAndPopulateCottontail() {
        this.cleanAndConnect();
        GrpcTestUtils.INSTANCE.createTestSchema(this.client);
        GrpcTestUtils.INSTANCE.createTestVectorEntity(this.client);
        GrpcTestUtils.INSTANCE.createTestEntity(this.client);
        GrpcTestUtils.INSTANCE.populateTestEntity(this.client);
        GrpcTestUtils.INSTANCE.populateVectorEntity(this.client);
        boolean bl = this.client.ping();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    public final void cleanAndConnect() {
        boolean bl = this.client.ping();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        GrpcTestUtils.INSTANCE.dropTestSchema(this.client);
        bl = this.client.ping();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    public final void cleanup() {
        GrpcTestUtils.INSTANCE.dropTestSchema(this.client);
        this.channel.shutdown();
        this.channel.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        this.embedded.shutdownAndWait();
    }
}

