/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.graph.GraphEvents;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.impl.IStream;
import com.hp.hpl.jena.rdf.model.impl.RDFDefaultErrorHandler;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.SyntaxError;
import com.hp.hpl.jena.shared.UnknownPropertyException;
import com.hp.hpl.jena.util.FileUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NTripleReader
implements RDFReader {
    static final Logger log = LoggerFactory.getLogger(NTripleReader.class);
    private Model model = null;
    private Hashtable<String, Resource> anons = new Hashtable();
    private IStream in = null;
    private boolean inErr = false;
    private int errCount = 0;
    private static final int sbLength = 200;
    private RDFErrorHandler errorHandler = new RDFDefaultErrorHandler();
    private String base;

    NTripleReader() {
    }

    @Override
    public void read(Model model, InputStream in, String base) {
        this.read(model, FileUtils.asUTF8(in), base);
    }

    @Override
    public void read(Model model, Reader reader, String base) {
        if (!(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader);
        }
        this.model = model;
        this.base = base == null ? "" : base + ": ";
        this.in = new IStream(reader);
        this.readRDF();
        if (this.errCount != 0) {
            throw new SyntaxError("unknown");
        }
    }

    @Override
    public void read(Model model, String url) {
        try {
            this.read(model, new InputStreamReader(new URL(url).openStream()), url);
        }
        catch (Exception e2) {
            throw new JenaException(e2);
        }
        finally {
            if (this.errCount != 0) {
                throw new SyntaxError("unknown");
            }
        }
    }

    @Override
    public Object setProperty(String propName, Object propValue) {
        this.errorHandler.error(new UnknownPropertyException(propName));
        return null;
    }

    @Override
    public RDFErrorHandler setErrorHandler(RDFErrorHandler errHandler) {
        RDFErrorHandler old = this.errorHandler;
        this.errorHandler = errHandler;
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readRDF() {
        try {
            this.model.notifyEvent(GraphEvents.startRead);
            this.unwrappedReadRDF();
        }
        finally {
            this.model.notifyEvent(GraphEvents.finishRead);
        }
    }

    protected final void unwrappedReadRDF() {
        Property predicate = null;
        while (!this.in.eof()) {
            while (!this.in.eof()) {
                this.inErr = false;
                this.skipWhiteSpace();
                if (this.in.eof()) {
                    return;
                }
                Resource subject = this.readResource();
                if (this.inErr) break;
                this.skipWhiteSpace();
                try {
                    Resource r = this.readResource();
                    if (this.inErr) break;
                    predicate = this.model.createProperty(r.getURI());
                }
                catch (Exception e1) {
                    this.errorHandler.fatalError(e1);
                }
                if (this.inErr) break;
                this.skipWhiteSpace();
                RDFNode object = this.readNode();
                if (this.inErr) break;
                this.skipWhiteSpace();
                if (this.badEOF() || !this.expect(".")) break;
                try {
                    this.model.add(subject, predicate, object);
                }
                catch (Exception e2) {
                    this.errorHandler.fatalError(e2);
                }
            }
            if (!this.inErr) continue;
            ++this.errCount;
            while (!this.in.eof() && this.in.readChar() != '\n') {
            }
        }
    }

    public Resource readResource() {
        char inChar = this.in.readChar();
        if (this.badEOF()) {
            System.err.println("**** Bad EOF");
            return null;
        }
        if (inChar == '_') {
            if (!this.expect(":")) {
                return null;
            }
            String name = this.readName();
            if (name == null) {
                this.syntaxError("expected bNode label");
                return null;
            }
            return this.lookupResource(name);
        }
        if (inChar == '<') {
            String uri = this.readURI();
            if (uri == null) {
                this.inErr = true;
                return null;
            }
            inChar = this.in.readChar();
            if (inChar != '>') {
                this.syntaxError("expected '>'");
                return null;
            }
            return this.model.createResource(uri);
        }
        this.syntaxError("unexpected input");
        return null;
    }

    public RDFNode readNode() {
        this.skipWhiteSpace();
        switch (this.in.nextChar()) {
            case '\"': {
                return this.readLiteral();
            }
            case '<': 
            case '_': {
                return this.readResource();
            }
        }
        this.syntaxError("unexpected input");
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Literal readLiteral() {
        StringBuffer lit = new StringBuffer(200);
        if (!this.expect("\"")) {
            return null;
        }
        while (true) {
            int inChar;
            block20: {
                block21: {
                    char c;
                    block23: {
                        block22: {
                            inChar = this.in.readChar();
                            if (this.badEOF()) {
                                return null;
                            }
                            if (inChar != 92) break block21;
                            c = this.in.readChar();
                            if (this.in.eof()) {
                                this.inErr = true;
                                return null;
                            }
                            if (c != 'n') break block22;
                            inChar = 10;
                            break block20;
                        }
                        if (c != 'r') break block23;
                        inChar = 13;
                        break block20;
                    }
                    if (c == 't') {
                        inChar = 9;
                        break block20;
                    } else if (c == '\\' || c == '\"') {
                        inChar = c;
                        break block20;
                    } else {
                        if (c != 'u') {
                            this.syntaxError("illegal escape sequence '" + c + "'");
                            return null;
                        }
                        inChar = this.readUnicode4Escape();
                        if (this.inErr) {
                            return null;
                        }
                    }
                    break block20;
                }
                if (inChar == 34) {
                    String lang;
                    if ('@' == this.in.nextChar()) {
                        this.expect("@");
                        lang = this.readLang();
                    } else if ('-' == this.in.nextChar()) {
                        this.expect("-");
                        this.deprecated("Language tags should be introduced with @ not -.");
                        lang = this.readLang();
                    } else {
                        lang = "";
                    }
                    if ('^' != this.in.nextChar()) {
                        return this.model.createLiteral(lit.toString(), lang);
                    }
                    String datatypeURI = null;
                    if (!this.expect("^^<")) {
                        this.syntaxError("ill-formed datatype");
                        return null;
                    }
                    datatypeURI = this.readURI();
                    if (datatypeURI == null || !this.expect(">")) {
                        return null;
                    }
                    if (lang.length() > 0) {
                        this.deprecated("Language tags are not permitted on typed literals.");
                    }
                    return this.model.createTypedLiteral(lit.toString(), datatypeURI);
                }
                if (inChar == 10 || inChar == 13) {
                    this.deprecated("Raw NL or CR not permitted in N-Triples data");
                    return null;
                }
            }
            lit = lit.append((char)inChar);
        }
    }

    private char readUnicode4Escape() {
        char[] buf = new char[]{this.in.readChar(), this.in.readChar(), this.in.readChar(), this.in.readChar()};
        if (this.badEOF()) {
            return '\u0000';
        }
        try {
            return (char)Integer.parseInt(new String(buf), 16);
        }
        catch (NumberFormatException e2) {
            this.syntaxError("bad unicode escape sequence");
            return '\u0000';
        }
    }

    private void deprecated(String s) {
        this.errorHandler.warning(new SyntaxError(this.syntaxErrorMessage("Deprecation warning", s, this.in.getLinepos(), this.in.getCharpos())));
    }

    private void syntaxError(String s) {
        this.errorHandler.error(new SyntaxError(this.syntaxErrorMessage("Syntax error", s, this.in.getLinepos(), this.in.getCharpos())));
        this.inErr = true;
    }

    private String readLang() {
        StringBuffer lang = new StringBuffer(15);
        char inChar;
        while (!Character.isWhitespace(inChar = this.in.nextChar()) && inChar != '.' && inChar != '^') {
            lang = lang.append(this.in.readChar());
        }
        return lang.toString();
    }

    private boolean badEOF() {
        if (this.in.eof()) {
            this.syntaxError("premature end of file");
        }
        return this.inErr;
    }

    protected String readURI() {
        StringBuffer uri = new StringBuffer(200);
        while (this.in.nextChar() != '>') {
            char inChar = this.in.readChar();
            if (inChar == '\\') {
                this.expect("u");
                inChar = this.readUnicode4Escape();
            }
            if (this.badEOF()) {
                return null;
            }
            uri = uri.append(inChar);
        }
        return uri.toString();
    }

    protected String readName() {
        char nextChar;
        StringBuffer name = new StringBuffer(200);
        while (Character.isLetterOrDigit(nextChar = this.in.nextChar()) || '-' == nextChar) {
            name = name.append(this.in.readChar());
            if (!this.badEOF()) continue;
            return null;
        }
        return name.toString();
    }

    private boolean expect(String str2) {
        for (int i = 0; i < str2.length(); ++i) {
            char want = str2.charAt(i);
            if (this.badEOF()) {
                return false;
            }
            char inChar = this.in.readChar();
            if (inChar == want) continue;
            this.syntaxError("expected \"" + str2 + "\"");
            return false;
        }
        return true;
    }

    protected void skipWhiteSpace() {
        while (Character.isWhitespace(this.in.nextChar()) || this.in.nextChar() == '#') {
            char inChar = this.in.readChar();
            if (this.in.eof()) {
                return;
            }
            if (inChar != '#') continue;
            while (inChar != '\n') {
                inChar = this.in.readChar();
                if (!this.in.eof()) continue;
                return;
            }
        }
    }

    protected Resource lookupResource(String name) {
        Resource r = this.anons.get(name);
        if (r == null) {
            r = this.model.createResource();
            this.anons.put(name, r);
        }
        return r;
    }

    protected String syntaxErrorMessage(String sort, String msg, int linepos, int charpos) {
        return this.base + sort + " at line " + linepos + " position " + charpos + ": " + msg;
    }
}

