/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb;

import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sdb.SDBException;
import com.hp.hpl.jena.sdb.assembler.AssemblerVocab;
import com.hp.hpl.jena.sdb.shared.Env;
import com.hp.hpl.jena.sdb.sql.MySQLEngineType;
import com.hp.hpl.jena.sdb.sql.SDBConnectionDesc;
import com.hp.hpl.jena.sdb.store.DatabaseType;
import com.hp.hpl.jena.sdb.store.FeatureSet;
import com.hp.hpl.jena.sdb.store.LayoutType;
import com.hp.hpl.jena.sparql.util.graph.GraphUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreDesc {
    private static Logger log = LoggerFactory.getLogger(StoreDesc.class);
    public SDBConnectionDesc connDesc = null;
    private DatabaseType dbType = null;
    private LayoutType layout = null;
    private FeatureSet featureSet = null;
    public MySQLEngineType engineType = null;

    public static StoreDesc read(String filename) {
        Model m = Env.fileManager().loadModel(filename);
        return StoreDesc.read(m);
    }

    public StoreDesc(String layoutName, String dbTypeName) {
        this(layoutName, dbTypeName, null);
    }

    public StoreDesc(String layoutName, String dbTypeName, FeatureSet featureSet) {
        this(LayoutType.fetch(layoutName), DatabaseType.fetch(dbTypeName), featureSet);
    }

    public StoreDesc(LayoutType layout, DatabaseType dbType) {
        this(layout, dbType, null);
    }

    public StoreDesc(LayoutType layout, DatabaseType dbType, FeatureSet featureSet) {
        this.layout = layout;
        this.dbType = dbType;
        if (featureSet == null) {
            featureSet = new FeatureSet();
        }
        this.featureSet = featureSet;
    }

    public LayoutType getLayout() {
        return this.layout;
    }

    public void setLayout(LayoutType layout) {
        this.layout = layout;
    }

    public static StoreDesc read(Model m) {
        Resource r = GraphUtils.getResourceByType(m, AssemblerVocab.StoreAssemblerType);
        if (r == null) {
            throw new SDBException("Can't find store description");
        }
        return StoreDesc.read(r);
    }

    public static StoreDesc read(Resource r) {
        return (StoreDesc)AssemblerBase.general.open(r);
    }

    public DatabaseType getDbType() {
        return this.dbType;
    }

    public void setDbType(DatabaseType dbType) {
        this.dbType = dbType;
    }
}

