/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.graph;

import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.sdb.SDBException;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.sql.SDBExceptionSQL;
import com.hp.hpl.jena.shared.Command;
import com.hp.hpl.jena.shared.JenaException;
import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionHandlerSDB
implements TransactionHandler {
    private static Logger log = LoggerFactory.getLogger(TransactionHandlerSDB.class);
    Connection sqlConnection;
    boolean inTransaction;

    public TransactionHandlerSDB(SDBConnection connection) {
        this.sqlConnection = connection.getSqlConnection();
        this.inTransaction = false;
    }

    @Override
    public boolean transactionsSupported() {
        return true;
    }

    @Override
    public synchronized void begin() {
        if (this.inTransaction) {
            log.warn("beginTransaction: Already in a transaction");
            throw new SDBException("Already in transaction");
        }
        try {
            this.sqlConnection.setAutoCommit(false);
            this.inTransaction = true;
        }
        catch (SQLException ex) {
            new SDBExceptionSQL("begin", ex);
        }
    }

    @Override
    public synchronized void commit() {
        if (!this.inTransaction) {
            log.warn("commit: Not in a transaction");
            return;
        }
        try {
            this.sqlConnection.commit();
            this.sqlConnection.setAutoCommit(true);
            this.inTransaction = false;
        }
        catch (SQLException ex) {
            new SDBExceptionSQL("commit", ex);
        }
    }

    @Override
    public synchronized void abort() {
        if (!this.inTransaction) {
            log.warn("abort: Not in a transaction");
            return;
        }
        try {
            this.sqlConnection.rollback();
            this.sqlConnection.setAutoCommit(true);
            this.inTransaction = false;
        }
        catch (SQLException ex) {
            new SDBExceptionSQL("abort", ex);
        }
    }

    public synchronized void abortFinally() {
        if (!this.inTransaction) {
            return;
        }
        this.abort();
    }

    public void abortSilent() {
        try {
            this.abortFinally();
        }
        catch (SDBExceptionSQL sDBExceptionSQL) {
            // empty catch block
        }
    }

    @Override
    public Object executeInTransaction(Command c) {
        try {
            this.begin();
            Object result = c.execute();
            this.commit();
            return result;
        }
        catch (SDBExceptionSQL e2) {
            this.abortFinally();
            throw e2;
        }
        catch (JenaException e3) {
            this.abortFinally();
            throw e3;
        }
        catch (Throwable e4) {
            this.abortFinally();
            throw new SDBException(e4);
        }
    }
}

