/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.layout2.index;

import com.hp.hpl.jena.sdb.layout2.TableDescNodes;
import com.hp.hpl.jena.sdb.layout2.TableDescQuads;
import com.hp.hpl.jena.sdb.layout2.TableDescTriples;
import com.hp.hpl.jena.sdb.layout2.hash.FmtLayout2HashMySQL;
import com.hp.hpl.jena.sdb.sql.MySQLEngineType;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.sql.SDBExceptionSQL;
import com.hp.hpl.jena.sdb.sql.SQLUtils;
import java.sql.SQLException;

public class FmtLayout2IndexMySQL
extends FmtLayout2HashMySQL {
    public FmtLayout2IndexMySQL(SDBConnection connection, MySQLEngineType tableType) {
        super(connection, tableType);
    }

    @Override
    protected void formatTableTriples() {
        this.dropTable(TableDescTriples.name());
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE " + TableDescTriples.name() + " (", "    s int  NOT NULL ,", "    p int  NOT NULL ,", "    o int  NOT NULL ,", "    PRIMARY KEY (s, p, o)", ") ENGINE=" + this.engineType.getEngineName()));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException formatting table '" + TableDescTriples.name() + "'", ex);
        }
    }

    @Override
    protected void formatTableQuads() {
        this.dropTable(TableDescQuads.name());
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE " + TableDescQuads.name() + " (", "    g int  NOT NULL ,", "    s int  NOT NULL ,", "    p int  NOT NULL ,", "    o int  NOT NULL ,", "    PRIMARY KEY (g, s, p, o)", ") ENGINE=" + this.engineType.getEngineName()));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException formatting table '" + TableDescTriples.name() + "'", ex);
        }
    }

    @Override
    protected void formatTableNodes() {
        this.dropTable(TableDescNodes.name());
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE " + TableDescNodes.name() + " (", "   id int unsigned NOT NULL auto_increment,", "   hash BIGINT NOT NULL DEFAULT 0,", "   lex LONGTEXT BINARY CHARACTER SET utf8 ,", "   lang VARCHAR(10) BINARY CHARACTER SET utf8 NOT NULL default '',", "   datatype VARCHAR(200) BINARY CHARACTER SET utf8 NOT NULL default '',", "   type int unsigned NOT NULL default '0',", "   PRIMARY KEY Id  (id)", ") ENGINE=" + this.engineType.getEngineName() + " DEFAULT CHARSET=utf8;"));
            this.connection().exec("CREATE UNIQUE INDEX Hash ON " + TableDescNodes.name() + " (hash)");
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException formatting table '" + TableDescNodes.name() + "'", ex);
        }
    }
}

