/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.sql;

import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sdb.SDBException;
import com.hp.hpl.jena.sdb.assembler.AssemblerVocab;
import com.hp.hpl.jena.sdb.sql.JDBC;
import com.hp.hpl.jena.sparql.util.graph.GraphUtils;
import com.hp.hpl.jena.util.FileManager;
import org.apache.jena.atlas.logging.Log;

public class SDBConnectionDesc {
    private String type = null;
    private String host = null;
    private String name = null;
    private String user = null;
    private String password = null;
    private String driver = null;
    private String jdbcURL = null;
    private String label = null;
    private int poolSize = 0;

    public static SDBConnectionDesc blank() {
        return new SDBConnectionDesc();
    }

    public static SDBConnectionDesc none() {
        SDBConnectionDesc x = new SDBConnectionDesc();
        x.jdbcURL = "jdbc:none";
        return x;
    }

    private SDBConnectionDesc() {
    }

    public static SDBConnectionDesc read(String filename) {
        Model m = FileManager.get().loadModel(filename);
        return SDBConnectionDesc.worker(m);
    }

    public static SDBConnectionDesc read(Model m) {
        return SDBConnectionDesc.worker(m);
    }

    private static SDBConnectionDesc worker(Model m) {
        Resource r = GraphUtils.getResourceByType(m, AssemblerVocab.SDBConnectionAssemblerType);
        if (r == null) {
            throw new SDBException("Can't find connection description");
        }
        SDBConnectionDesc desc = (SDBConnectionDesc)AssemblerBase.general.open(r);
        desc.initJDBC();
        return desc;
    }

    private void initJDBC() {
        if (this.jdbcURL == null) {
            this.jdbcURL = JDBC.makeURL(this.type, this.host, this.name, this.user, this.password);
        }
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getJdbcURL() {
        this.initJDBC();
        return this.jdbcURL;
    }

    public void setJdbcURL(String jdbcURL) {
        this.jdbcURL = jdbcURL;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int size) {
        this.poolSize = size;
    }

    public void setPoolSize(String str2) {
        if (str2 == null) {
            this.poolSize = 0;
            return;
        }
        try {
            this.poolSize = Integer.parseInt(str2);
        }
        catch (NumberFormatException ex) {
            Log.warn(this, "Can't parse as integer: " + str2);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }
}

