/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.util;

import java.text.StringCharacterIterator;

public class RegexUtils {
    static final char[] metaChars = new char[]{'^', '$', '.', '*', '?', '+', '(', ')', '[', ']', '\\'};

    public static boolean noMetaChars(String string, int fromIndex) {
        return RegexUtils.noMetaChars(string, fromIndex, string.length());
    }

    public static boolean noMetaChars(String string, int fromIndex, int endIndex) {
        char ch;
        StringCharacterIterator iter = new StringCharacterIterator(string, fromIndex, endIndex, fromIndex);
        while ((ch = iter.next()) != '\uffff') {
            for (char mc : metaChars) {
                if (mc != ch) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isSimpleStartsWith(String pattern) {
        if (pattern.length() < 1) {
            return false;
        }
        return pattern.charAt(0) == '^' && RegexUtils.noMetaChars(pattern, 1);
    }

    public static boolean isSimpleAnchored(String pattern) {
        if (pattern.length() < 2) {
            return false;
        }
        return pattern.charAt(0) == '^' && pattern.charAt(pattern.length() - 1) == '$' && RegexUtils.noMetaChars(pattern, 1, pattern.length() - 1);
    }

    public static boolean isSimpleEndsWith(String pattern) {
        if (pattern.length() < 1) {
            return false;
        }
        return pattern.charAt(pattern.length() - 1) == '$' && RegexUtils.noMetaChars(pattern, 0, pattern.length() - 1);
    }

    public static String regexToLike(String pattern) {
        if (RegexUtils.isSimpleAnchored(pattern)) {
            return pattern.substring(1, pattern.length() - 1);
        }
        if (RegexUtils.isSimpleStartsWith(pattern)) {
            return pattern.substring(1) + "%";
        }
        if (RegexUtils.isSimpleEndsWith(pattern)) {
            return "%" + pattern.substring(0, pattern.length() - 1);
        }
        if (RegexUtils.noMetaChars(pattern, 0)) {
            return "%" + pattern + "%";
        }
        return null;
    }
}

