/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.iterator;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingFactory;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import com.hp.hpl.jena.sparql.expr.ExprAggregator;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.IteratorDelayedInitialization;
import org.apache.jena.atlas.lib.MultiMap;
import org.apache.jena.atlas.lib.Pair;

public class QueryIterGroup
extends QueryIterPlainWrapper {
    private final QueryIterator embeddedIterator;
    private static Pair<Var, Accumulator> placeholder = Pair.create(null, null);

    public QueryIterGroup(QueryIterator qIter, VarExprList groupVars, List<ExprAggregator> aggregators, ExecutionContext execCxt) {
        super(null, execCxt);
        this.embeddedIterator = qIter;
        Iterator<Binding> iter = QueryIterGroup.calc(qIter, groupVars, aggregators, execCxt);
        this.setIterator(iter);
    }

    @Override
    public void requestCancel() {
        this.embeddedIterator.cancel();
        super.requestCancel();
    }

    private static Iterator<Binding> calc(final QueryIterator iter, final VarExprList groupVarExpr, final List<ExprAggregator> aggregators, final ExecutionContext execCxt) {
        return new IteratorDelayedInitialization<Binding>(){

            @Override
            protected Iterator<Binding> initializeIterator() {
                boolean noAggregators = aggregators == null || aggregators.size() == 0;
                MultiMap<Binding, Pair<Var, Accumulator>> accumulators = MultiMap.createMapList();
                while (iter.hasNext()) {
                    Binding b = iter.nextBinding();
                    Binding key = QueryIterGroup.genKey(groupVarExpr, b, execCxt);
                    if (noAggregators) {
                        accumulators.put(key, placeholder);
                        continue;
                    }
                    Collection accs = accumulators.get(key);
                    if (accs == null) {
                        for (ExprAggregator agg : aggregators) {
                            Accumulator x = agg.getAggregator().createAccumulator();
                            Var v = agg.getVar();
                            accumulators.put(key, Pair.create(v, x));
                        }
                        accs = accumulators.get(key);
                    }
                    for (Pair pair : accs) {
                        ((Accumulator)pair.getRight()).accumulate(b, execCxt);
                    }
                }
                if (accumulators.isEmpty()) {
                    if (noAggregators) {
                        return Iter.nullIterator();
                    }
                    BindingMap binding = BindingFactory.create();
                    for (ExprAggregator agg : aggregators) {
                        Var v = agg.getVar();
                        Node value = agg.getAggregator().getValueEmpty();
                        if (value == null) continue;
                        binding.add(v, value);
                    }
                    if (binding == null) {
                        return Iter.nullIterator();
                    }
                    return Iter.singletonIter(binding);
                }
                if (noAggregators) {
                    return accumulators.keys().iterator();
                }
                ArrayList<BindingMap> results = new ArrayList<BindingMap>();
                for (Binding k : accumulators.keys()) {
                    Collection accs = accumulators.get(k);
                    BindingMap b = BindingFactory.create(k);
                    for (Pair pair : accs) {
                        Node n;
                        Var v = (Var)pair.getLeft();
                        NodeValue value = ((Accumulator)pair.getRight()).getValue();
                        Node node = n = value == null ? null : value.asNode();
                        if (v == null || n == null) continue;
                        b.add(v, n);
                    }
                    results.add(b);
                }
                return results.iterator();
            }
        };
    }

    private static Binding genKey(VarExprList vars, Binding binding, ExecutionContext execCxt) {
        return QueryIterGroup.copyProject(vars, binding, execCxt);
    }

    private static Binding copyProject(VarExprList vars, Binding binding, ExecutionContext execCxt) {
        BindingMap x = BindingFactory.create();
        for (Var var : vars.getVars()) {
            Node node = vars.get(var, binding, execCxt);
            if (node == null) continue;
            x.add(var, node);
        }
        return x;
    }
}

