/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.ReadWrite;
import com.hp.hpl.jena.tdb.StoreConnection;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.TDBFactory;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.transaction.DatasetGraphTxn;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.riot.out.NQuadsWriter;

public class TDBBackup {
    public static void backup(Location location, String backupfile) {
        try {
            OutputStream out = new FileOutputStream(backupfile);
            out = new BufferedOutputStream(out);
            TDBBackup.backup(location, out);
            out.close();
        }
        catch (FileNotFoundException e2) {
            Log.warn(TDBBackup.class, "File not found: " + backupfile);
            throw new TDBException("File not found: " + backupfile);
        }
        catch (IOException e3) {
            IO.exception(e3);
        }
    }

    public static void backup(Location location, OutputStream backupfile) {
        Dataset ds = TDBFactory.createDataset(location);
        StoreConnection sConn = StoreConnection.make(location);
        DatasetGraphTxn dsg = sConn.begin(ReadWrite.READ, "backup");
        NQuadsWriter.write(backupfile, dsg);
        dsg.end();
    }
}

