/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store.bulkloader;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.tdb.index.TupleIndex;
import com.hp.hpl.jena.tdb.nodetable.NodeTupleTable;
import com.hp.hpl.jena.tdb.store.NodeId;
import com.hp.hpl.jena.tdb.store.bulkloader.BuilderSecondaryIndexesSequential;
import com.hp.hpl.jena.tdb.store.bulkloader.LoadMonitor;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.ArrayUtils;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.atlas.lib.Sync;
import org.apache.jena.atlas.lib.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoaderNodeTupleTable
implements Closeable,
Sync {
    private LoadMonitor monitor = null;
    private boolean doIncremental = false;
    private int numIndexes;
    private TupleIndex primaryIndex;
    private TupleIndex[] secondaryIndexes;
    private NodeTupleTable nodeTupleTable;
    private boolean dropAndRebuildIndexes;
    private long count = 0L;
    private String itemsName;
    private static Logger logLoad = LoggerFactory.getLogger("com.hp.hpl.jena.tdb.loader");
    private static Object lock = new Object();

    public LoaderNodeTupleTable(NodeTupleTable nodeTupleTable, String itemsName, LoadMonitor monitor) {
        this.nodeTupleTable = nodeTupleTable;
        this.monitor = monitor;
        this.doIncremental = false;
        this.itemsName = itemsName;
    }

    protected void loadPrepare() {
        boolean bl = this.dropAndRebuildIndexes = !this.doIncremental;
        if (!this.nodeTupleTable.isEmpty()) {
            this.dropAndRebuildIndexes = false;
        }
        if (this.dropAndRebuildIndexes) {
            this.monitor.print("** Load empty %s table", this.itemsName);
            this.dropSecondaryIndexes();
        } else {
            this.monitor.print("** Load into %s table with existing data", this.itemsName);
        }
    }

    protected void loadSecondaryIndexes() {
        if (this.dropAndRebuildIndexes) {
            this.createSecondaryIndexes();
        }
    }

    public void loadStart() {
        this.monitor.startLoad();
    }

    public void loadFinish() {
        this.monitor.finishLoad();
    }

    public void loadDataStart() {
        this.monitor.startDataPhase();
        this.loadPrepare();
    }

    public void load(Node ... nodes) {
        try {
            ++this.count;
            this.monitor.dataItem();
            this.nodeTupleTable.addRow(nodes);
        }
        catch (RuntimeException ex) {
            System.err.println(Iter.asString(Arrays.asList(nodes)));
            ex.printStackTrace(System.err);
        }
    }

    public void loadDataFinish() {
        this.monitor.finishDataPhase();
    }

    public void loadIndexStart() {
        if (this.count > 0L) {
            this.monitor.startIndexPhase();
            this.loadSecondaryIndexes();
        }
    }

    public void loadIndexFinish() {
        if (this.count > 0L) {
            this.monitor.finishIndexPhase();
        }
    }

    public void sync(boolean force) {
    }

    @Override
    public void sync() {
    }

    @Override
    public void close() {
        this.sync();
    }

    private void dropSecondaryIndexes() {
        this.numIndexes = this.nodeTupleTable.getTupleTable().numIndexes();
        this.primaryIndex = this.nodeTupleTable.getTupleTable().getIndex(0);
        this.secondaryIndexes = ArrayUtils.alloc(TupleIndex.class, this.numIndexes - 1);
        System.arraycopy(this.nodeTupleTable.getTupleTable().getIndexes(), 1, this.secondaryIndexes, 0, this.numIndexes - 1);
        for (int i = 1; i < this.numIndexes; ++i) {
            this.nodeTupleTable.getTupleTable().setTupleIndex(i, null);
        }
    }

    private void createSecondaryIndexes() {
        BuilderSecondaryIndexesSequential builder = new BuilderSecondaryIndexesSequential(this.monitor);
        builder.createSecondaryIndexes(this.primaryIndex, this.secondaryIndexes);
        for (int i = 1; i < this.numIndexes; ++i) {
            this.nodeTupleTable.getTupleTable().setTupleIndex(i, this.secondaryIndexes[i - 1]);
        }
    }

    static void copyIndex(Iterator<Tuple<NodeId>> srcIter, TupleIndex[] destIndexes, String label, LoadMonitor monitor) {
        monitor.startIndex(label);
        long counter = 0L;
        while (srcIter.hasNext()) {
            ++counter;
            Tuple<NodeId> tuple = srcIter.next();
            monitor.indexItem();
            for (TupleIndex destIdx : destIndexes) {
                if (destIdx == null) continue;
                destIdx.add(tuple);
            }
        }
        monitor.finishIndex(label);
    }

    private static void sync(TupleIndex[] indexes) {
        for (TupleIndex idx : indexes) {
            if (idx == null) continue;
            idx.sync();
        }
    }

    private static boolean tickPoint(long counter, long quantum) {
        return counter % quantum == 0L;
    }
}

