/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import com.hp.hpl.jena.rdf.model.impl.RDFWriterFImpl;
import com.hp.hpl.jena.xmloutput.impl.Abbreviated;
import com.hp.hpl.jena.xmloutput.impl.Basic;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.adapters.JenaReadersWriters;

public class IO_JenaWriters {
    private static Map<String, RDFFormat> mapJenaNameToFormat = new HashMap<String, RDFFormat>();

    public static RDFFormat getFormatForJenaWriter(String jenaName) {
        return mapJenaNameToFormat.get(jenaName);
    }

    public static void setFormatForJenaWriter(String jenaName, RDFFormat format) {
        mapJenaNameToFormat.put(jenaName, format);
    }

    public static Collection<String> getJenaWriterNames() {
        return mapJenaNameToFormat.keySet();
    }

    public static void wireIntoJena() {
        IO_JenaWriters.setFormatForJenaWriter("RDF/XML", RDFFormat.RDFXML_PLAIN);
        IO_JenaWriters.setFormatForJenaWriter("RDF/XML-ABBREV", RDFFormat.RDFXML_ABBREV);
        IO_JenaWriters.setFormatForJenaWriter("N-TRIPLE", RDFFormat.NTRIPLES);
        IO_JenaWriters.setFormatForJenaWriter("NT", RDFFormat.NTRIPLES);
        IO_JenaWriters.setFormatForJenaWriter("N-TRIPLES", RDFFormat.NTRIPLES);
        IO_JenaWriters.setFormatForJenaWriter("N-Triples", RDFFormat.NTRIPLES);
        IO_JenaWriters.setFormatForJenaWriter("N3", RDFFormat.TURTLE);
        IO_JenaWriters.setFormatForJenaWriter("N3-PP", RDFFormat.TURTLE_PRETTY);
        IO_JenaWriters.setFormatForJenaWriter("N3-PLAIN", RDFFormat.TURTLE_BLOCKS);
        IO_JenaWriters.setFormatForJenaWriter("N3-TRIPLES", RDFFormat.TURTLE_FLAT);
        IO_JenaWriters.setFormatForJenaWriter("N3-TRIPLE", RDFFormat.TURTLE_FLAT);
        IO_JenaWriters.setFormatForJenaWriter("TURTLE", RDFFormat.TURTLE);
        IO_JenaWriters.setFormatForJenaWriter("Turtle", RDFFormat.TURTLE);
        IO_JenaWriters.setFormatForJenaWriter("TTL", RDFFormat.TURTLE);
        IO_JenaWriters.setFormatForJenaWriter("RDF/JSON", RDFFormat.RDFJSON);
        IO_JenaWriters.setFormatForJenaWriter("RDFJSON", RDFFormat.RDFJSON);
        IO_JenaWriters.registerForModelWrite("RDF/XML", Basic.class);
        IO_JenaWriters.registerForModelWrite("RDF/XML-ABBREV", Abbreviated.class);
        IO_JenaWriters.registerForModelWrite("N-TRIPLE", JenaReadersWriters.RDFWriterRIOT_NTriples.class);
        IO_JenaWriters.registerForModelWrite("N-TRIPLES", JenaReadersWriters.RDFWriterRIOT_NTriples.class);
        IO_JenaWriters.registerForModelWrite("N-Triples", JenaReadersWriters.RDFWriterRIOT_NTriples.class);
        IO_JenaWriters.registerForModelWrite("NT", JenaReadersWriters.RDFWriterRIOT_NTriples.class);
        IO_JenaWriters.registerForModelWrite("N3", JenaReadersWriters.RDFWriterRIOT_N3.class);
        IO_JenaWriters.registerForModelWrite("N3-PP", JenaReadersWriters.RDFWriterRIOT_N3_PP.class);
        IO_JenaWriters.registerForModelWrite("N3-PLAIN", JenaReadersWriters.RDFWriterRIOT_N3Plain.class);
        IO_JenaWriters.registerForModelWrite("N3-TRIPLES", JenaReadersWriters.RDFWriterRIOT_N3Triples.class);
        IO_JenaWriters.registerForModelWrite("N3-TRIPLE", JenaReadersWriters.RDFWriterRIOT_N3TriplesAlt.class);
        IO_JenaWriters.registerForModelWrite("TURTLE", JenaReadersWriters.RDFWriterRIOT_Turtle.class);
        IO_JenaWriters.registerForModelWrite("Turtle", JenaReadersWriters.RDFWriterRIOT_Turtle1.class);
        IO_JenaWriters.registerForModelWrite("TTL", JenaReadersWriters.RDFWriterRIOT_Turtle2.class);
        IO_JenaWriters.registerForModelWrite("RDF/JSON", JenaReadersWriters.RDFWriterRIOT_RDFJSON.class);
        IO_JenaWriters.registerForModelWrite("RDFJSON", JenaReadersWriters.RDFWriterRIOT_RDFJSON.class);
    }

    public static void resetJena() {
        RDFWriterFImpl.setBaseWriterClassName("RDF/XML", "com.hp.hpl.jena.xmloutput.impl.Basic");
        RDFWriterFImpl.setBaseWriterClassName("RDF/XML-ABBREV", "com.hp.hpl.jena.xmloutput.impl.Abbreviated");
        RDFWriterFImpl.setBaseWriterClassName("N-TRIPLE", "com.hp.hpl.jena.rdf.model.impl.NTripleWriter");
        RDFWriterFImpl.setBaseWriterClassName("N-TRIPLES", "com.hp.hpl.jena.rdf.model.impl.NTripleWriter");
        RDFWriterFImpl.setBaseWriterClassName("N-Triples", "com.hp.hpl.jena.rdf.model.impl.NTripleWriter");
        RDFWriterFImpl.setBaseWriterClassName("N3", "com.hp.hpl.jena.n3.N3JenaWriter");
        RDFWriterFImpl.setBaseWriterClassName("N3-PP", "com.hp.hpl.jena.n3.N3JenaWriterPP");
        RDFWriterFImpl.setBaseWriterClassName("N3-PLAIN", "com.hp.hpl.jena.n3.N3TurtleJenaWriter");
        RDFWriterFImpl.setBaseWriterClassName("N3-TRIPLES", "com.hp.hpl.jena.n3.N3TurtleJenaWriter");
        RDFWriterFImpl.setBaseWriterClassName("N3-TRIPLE", "com.hp.hpl.jena.n3.N3JenaWriterTriples");
        RDFWriterFImpl.setBaseWriterClassName("TURTLE", "com.hp.hpl.jena.n3.N3TurtleJenaWriter");
        RDFWriterFImpl.setBaseWriterClassName("Turtle", "com.hp.hpl.jena.n3.N3TurtleJenaWriter");
        RDFWriterFImpl.setBaseWriterClassName("TTL", "com.hp.hpl.jena.n3.N3TurtleJenaWriter");
    }

    public static void registerForModelWrite(String name, Class<?> cls) {
        RDFWriterFImpl.setBaseWriterClassName(name, cls.getName());
    }
}

