/*
 * Decompiled with CFR 0.152.
 */
package sdb.cmd;

import arq.cmd.CmdException;
import arq.cmdline.ArgDecl;
import arq.cmdline.CmdArgModule;
import arq.cmdline.CmdGeneral;
import arq.cmdline.ModBase;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import java.util.List;

public class ModLogSQL
extends ModBase {
    protected final ArgDecl argDeclLogSQL = new ArgDecl(true, "log", new String[0]);

    @Override
    public void registerWith(CmdGeneral cmdLine) {
        cmdLine.getUsage().startCategory("DB logging");
        cmdLine.add(this.argDeclLogSQL, "--log=", "SQL logging [none, all, query, exceptions, statement]");
    }

    @Override
    public void processArgs(CmdArgModule cmdLine) {
        List<String> vals = cmdLine.getValues(this.argDeclLogSQL);
        for (String v : vals) {
            if (v.equalsIgnoreCase("none")) {
                SDBConnection.logSQLExceptions = false;
                SDBConnection.logSQLQueries = false;
                SDBConnection.logSQLStatements = false;
                continue;
            }
            if (v.equalsIgnoreCase("query") || v.equalsIgnoreCase("queries")) {
                SDBConnection.logSQLQueries = true;
                continue;
            }
            if (v.equalsIgnoreCase("exception") || v.equalsIgnoreCase("exceptions")) {
                SDBConnection.logSQLExceptions = true;
                continue;
            }
            if (v.equalsIgnoreCase("statement") || v.equalsIgnoreCase("statements")) {
                SDBConnection.logSQLStatements = true;
                continue;
            }
            if (v.equalsIgnoreCase("all") || v.equalsIgnoreCase("sql")) {
                SDBConnection.logSQLExceptions = true;
                SDBConnection.logSQLQueries = true;
                SDBConnection.logSQLStatements = true;
                continue;
            }
            throw new CmdException("Not recognized as a log form: " + v);
        }
    }
}

