/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.compiler;

import com.hp.hpl.jena.sdb.SDB;
import com.hp.hpl.jena.sdb.compiler.ConditionCompiler;
import com.hp.hpl.jena.sdb.compiler.OpLibSDB;
import com.hp.hpl.jena.sdb.compiler.OpSQL;
import com.hp.hpl.jena.sdb.compiler.QuadBlockCompiler;
import com.hp.hpl.jena.sdb.compiler.QueryCompiler;
import com.hp.hpl.jena.sdb.compiler.SDB_QC;
import com.hp.hpl.jena.sdb.compiler.TransformSDB;
import com.hp.hpl.jena.sdb.compiler.rewrite.QuadBlockRewriteCompiler;
import com.hp.hpl.jena.sdb.core.SDBRequest;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlNode;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlSelectBlock;
import com.hp.hpl.jena.sdb.store.SQLBridge;
import com.hp.hpl.jena.sdb.store.SQLBridgeFactory;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVars;
import com.hp.hpl.jena.sparql.algebra.OpVisitorBase;
import com.hp.hpl.jena.sparql.algebra.OpWalker;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.Transformer;
import com.hp.hpl.jena.sparql.algebra.op.OpDistinct;
import com.hp.hpl.jena.sparql.algebra.op.OpExt;
import com.hp.hpl.jena.sparql.algebra.op.OpModifier;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpSlice;
import com.hp.hpl.jena.sparql.core.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class QueryCompilerMain
implements QueryCompiler {
    protected SDBRequest request;

    public QueryCompilerMain(SDBRequest request) {
        this.request = request;
    }

    @Override
    public Op compile(Op op) {
        Op op2;
        QuadBlockCompiler quadCompiler = this.createQuadBlockCompiler();
        if (this.request.getContext().isTrue(SDB.useQuadRewrite)) {
            quadCompiler = new QuadBlockRewriteCompiler(this.request, quadCompiler);
        }
        boolean b = this.request.LimitOffsetTranslation;
        this.request.LimitOffsetTranslation = false;
        TransformSDB t = new TransformSDB(this.request, quadCompiler);
        Op patternOp = op2 = Transformer.transform(t, op);
        while (patternOp instanceof OpModifier) {
            patternOp = ((OpModifier)patternOp).getSubOp();
        }
        boolean patternIsOneSQLStatement = SDB_QC.isOpSQL(patternOp);
        OpWalker.walk(op2, new SqlNodesFinisher(patternIsOneSQLStatement));
        this.request.LimitOffsetTranslation = b;
        Op op3 = this.postProcessSQL(op2);
        return op3;
    }

    protected abstract Op postProcessSQL(Op var1);

    public abstract QuadBlockCompiler createQuadBlockCompiler();

    @Override
    public ConditionCompiler getConditionCompiler() {
        return null;
    }

    protected static Op rewriteLimitOffset(Op op, SDBRequest request) {
        LimitOffsetOptimizer t = new LimitOffsetOptimizer(request);
        return Transformer.transform(t, op);
    }

    protected static Op rewriteDistinct(Op op, SDBRequest request) {
        DistinctOptimizer t = new DistinctOptimizer(request);
        return Transformer.transform(t, op);
    }

    private static class DistinctOptimizer
    extends TransformCopy {
        private final SDBRequest request;

        public DistinctOptimizer(SDBRequest request) {
            this.request = request;
        }

        @Override
        public Op transform(OpDistinct opDistinct, Op subOp) {
            if (!this.request.DistinctTranslation) {
                return super.transform(opDistinct, subOp);
            }
            if (!SDB_QC.isOpSQL(subOp)) {
                return super.transform(opDistinct, subOp);
            }
            SqlNode sqlSubOp = ((OpSQL)subOp).getSqlNode();
            SqlNode n = SqlSelectBlock.distinct(this.request, sqlSubOp);
            return new OpSQL(n, opDistinct, this.request);
        }
    }

    private static class LimitOffsetOptimizer
    extends TransformCopy {
        private final SDBRequest request;

        public LimitOffsetOptimizer(SDBRequest request) {
            this.request = request;
        }

        @Override
        public Op transform(OpSlice opSlice, Op subOp) {
            if (!this.request.LimitOffsetTranslation) {
                return super.transform(opSlice, subOp);
            }
            boolean canHandle = false;
            if (SDB_QC.isOpSQL(subOp)) {
                canHandle = true;
            } else if (SDB_QC.isOpSQL(OpLibSDB.sub(OpLibSDB.asProject(subOp)))) {
                return this.transformSliceProject(opSlice, (OpProject)subOp);
            }
            if (!SDB_QC.isOpSQL(subOp)) {
                return super.transform(opSlice, subOp);
            }
            return this.transformSlice(opSlice, (OpSQL)subOp);
        }

        private Op transformSlice(OpSlice opSlice, OpSQL opSQL) {
            SqlNode sqlSubOp = opSQL.getSqlNode();
            SqlNode n = SqlSelectBlock.slice(this.request, sqlSubOp, opSlice.getStart(), opSlice.getLength());
            OpSQL x = new OpSQL(n, opSlice, this.request);
            x.setBridge(opSQL.getBridge());
            return x;
        }

        public Op transformSliceProject(OpSlice opSlice, OpProject opProject) {
            Op subOp = opProject.getSubOp();
            if (!SDB_QC.isOpSQL(subOp)) {
                return super.transform(opSlice, (Op)opProject);
            }
            OpSQL opSQL = (OpSQL)subOp;
            SqlNode sqlSubOp = opSQL.getSqlNode();
            List<Var> pv = opProject.getVars();
            SqlNode n = SqlSelectBlock.slice(this.request, sqlSubOp, opSlice.getStart(), opSlice.getLength());
            OpSQL x = new OpSQL(n, opProject, this.request);
            x.setBridge(opSQL.getBridge());
            return new OpProject(x, pv);
        }
    }

    private class SqlNodesFinisher
    extends OpVisitorBase {
        private boolean justProjectVars;

        SqlNodesFinisher(boolean justProjectVars) {
            this.justProjectVars = justProjectVars;
        }

        @Override
        public void visit(OpExt op) {
            if (!(op instanceof OpSQL)) {
                super.visit(op);
                return;
            }
            OpSQL opSQL = (OpSQL)op;
            List<Var> projectVars = null;
            if (this.justProjectVars && QueryCompilerMain.this.request.getQuery() != null) {
                projectVars = SDB_QC.queryOutVars(QueryCompilerMain.this.request.getQuery());
            } else {
                Set<Var> tmp = OpVars.visibleVars(opSQL.getOriginal());
                projectVars = new ArrayList<Var>(tmp);
            }
            SqlNode sqlNode = opSQL.getSqlNode();
            SQLBridgeFactory f = QueryCompilerMain.this.request.getStore().getSQLBridgeFactory();
            SQLBridge bridge = f.create(QueryCompilerMain.this.request, sqlNode, projectVars);
            bridge.build();
            sqlNode = bridge.getSqlNode();
            opSQL.setBridge(bridge);
            opSQL.resetSqlNode(sqlNode);
        }
    }
}

