/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.layout2.expr;

import com.hp.hpl.jena.sdb.SDBException;
import com.hp.hpl.jena.sdb.compiler.SDBConstraint;
import com.hp.hpl.jena.sdb.core.ExprPattern;
import com.hp.hpl.jena.sdb.core.Scope;
import com.hp.hpl.jena.sdb.core.sqlexpr.S_And;
import com.hp.hpl.jena.sdb.core.sqlexpr.S_Equal;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlColumn;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlConstant;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlExpr;
import com.hp.hpl.jena.sdb.exprmatch.MapResult;
import com.hp.hpl.jena.sdb.layout2.ValueType;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import org.slf4j.LoggerFactory;

class StringEqualsSqlGen
extends SDBConstraint {
    ExprPattern exprPattern;
    boolean completeConstraint;

    public StringEqualsSqlGen(Expr expr, ExprPattern exprPattern, boolean completeConstraint) {
        super(expr, completeConstraint);
        this.exprPattern = exprPattern;
    }

    @Override
    public SDBConstraint substitute(Binding binding) {
        return new StringEqualsSqlGen(this.getExpr().copySubstitute(binding), this.exprPattern, super.isComplete());
    }

    @Override
    public SqlExpr compile(Scope scope) {
        MapResult rMap = this.exprPattern.match(this.getExpr());
        if (rMap == null) {
            throw new SDBException("Couldn't compile after all: " + this.getExpr());
        }
        Var var = rMap.get("a1").getExprVar().asVar();
        String str2 = rMap.get("a2").getConstant().getString();
        if (!scope.hasColumnForVar(var)) {
            LoggerFactory.getLogger(this.getClass()).error("Variable '" + var + "' not in scope");
            return null;
        }
        SqlColumn vCol = scope.findScopeForVar(var).getColumn();
        SqlColumn lexCol = new SqlColumn(vCol.getTable(), "lex");
        SqlColumn vTypeCol = new SqlColumn(vCol.getTable(), "type");
        S_Equal isStr = new S_Equal(vTypeCol, new SqlConstant(ValueType.STRING.getTypeId()));
        isStr.addNote("is a string");
        S_Equal strEquals = new S_Equal(lexCol, new SqlConstant(str2));
        isStr.addNote(this.getExpr().toString());
        return new S_And(isStr, strEquals);
    }
}

