/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.script;

import arq.cmdline.CmdLineArgs;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sdb.SDBException;
import com.hp.hpl.jena.sdb.script.ScriptVocab;
import com.hp.hpl.jena.sdb.util.Pair;
import com.hp.hpl.jena.sparql.util.graph.GraphUtils;
import com.hp.hpl.jena.util.FileManager;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class CmdDesc {
    String classname = null;
    List<Pair<String, String>> namedArgs = new ArrayList<Pair<String, String>>();
    List<String> posnArgs = new ArrayList<String>();

    public static CmdDesc read(String filename) {
        ScriptVocab.init();
        Model m = FileManager.get().loadModel(filename);
        return CmdDesc.worker(m);
    }

    public static void run(String filename) {
        CmdDesc desc = CmdDesc.read(filename);
        System.out.println(desc);
        try {
            String cmd = desc.getCmd();
            Class<?> c = Class.forName(cmd);
            Method m = c.getMethod("mainNoExit", String[].class);
            m.invoke(null, new Object[]{desc.asStringArray()});
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    private static CmdDesc worker(Model m) {
        Resource r = GraphUtils.getResourceByType(m, ScriptVocab.CommandLineType);
        if (r == null) {
            throw new SDBException("Can't find command line description");
        }
        return (CmdDesc)AssemblerBase.general.open(r);
    }

    public void addNamedArg(String name, String value) {
        this.namedArgs.add(new Pair<String, String>(name, value));
    }

    public void addNamedArg(String name) {
        this.addNamedArg(name, null);
    }

    public void addPosn(String x) {
        this.posnArgs.add(x);
    }

    public String getCmd() {
        return this.classname;
    }

    public void setCmd(String cname) {
        this.classname = cname;
    }

    public void set(CmdLineArgs cmdLineArgs) {
        for (Pair<String, String> p : this.namedArgs) {
            cmdLineArgs.addArg(p.car(), p.cdr());
        }
        for (String a : this.posnArgs) {
            cmdLineArgs.addPositional(a);
        }
    }

    public String[] asStringArray() {
        ArrayList<String> x = new ArrayList<String>();
        for (Pair<String, String> p : this.namedArgs) {
            x.add(p.car());
            x.add(p.cdr());
        }
        for (String a : this.posnArgs) {
            x.add(a);
        }
        return x.toArray(new String[x.size()]);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getCmd());
        String sep = " ";
        for (Pair<String, String> p : this.namedArgs) {
            sb.append(sep).append(p.car()).append("=").append(p.cdr());
            sep = " ";
        }
        for (String a : this.posnArgs) {
            sb.append(sep).append(a);
            sep = " ";
        }
        return sb.toString();
    }
}

