/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.sql;

import com.hp.hpl.jena.sdb.sql.ResultSetJDBC;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class RS {
    static String lead = "| ";
    static String sep = " | ";
    static String trail = "| ";

    public static void close(ResultSetJDBC rs) {
        if (rs != null) {
            rs.close();
        }
    }

    public static void close(Statement s) {
        try {
            if (s != null) {
                s.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void consume(ResultSet resultSet) throws SQLException {
        while (resultSet.next()) {
        }
        resultSet.close();
    }

    public static void printResultSet(ResultSet resultSet) throws SQLException {
        RS.printResultSet(System.out, resultSet);
    }

    public static void printResultSet(PrintStream out, ResultSet resultSet) throws SQLException {
        ResultSetMetaData rsmd = resultSet.getMetaData();
        List<List<String>> rows = RS.pass0(resultSet);
        int[] colWidths = RS.pass1(rsmd, rows);
        RS.fmtRow(out, rsmd, "+-", "---", '-', "-+", colWidths);
        out.print("| ");
        for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
            if (i != 1) {
                out.print(" | ");
            }
            RS.fmt(out, rsmd.getColumnLabel(i), colWidths[i]);
        }
        out.print(" |");
        out.println();
        RS.fmtRow(out, rsmd, "| ", " | ", '=', " |", colWidths);
        for (List<String> x : rows) {
            out.print("| ");
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                if (i != 1) {
                    out.print(sep);
                }
                String s = x.get(i);
                RS.fmt(out, s, colWidths[i]);
            }
            out.print(" |");
            out.println();
        }
        RS.fmtRow(out, rsmd, "+-", "---", '-', "-+", colWidths);
    }

    static void fmtRow(PrintStream out, ResultSetMetaData rsmd, String lead, String sep, char pad, String trail, int[] colWidths) throws SQLException {
        out.print(lead);
        for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
            if (i != 1) {
                out.print(sep);
            }
            RS.fmt(out, "", colWidths[i], pad);
        }
        out.print(trail);
        out.println();
    }

    static List<List<String>> pass0(ResultSet resultSet) throws SQLException {
        ResultSetMetaData rsmd = resultSet.getMetaData();
        int N = rsmd.getColumnCount();
        ArrayList<List<String>> x = new ArrayList<List<String>>();
        while (resultSet.next()) {
            ArrayList<String> z = new ArrayList<String>();
            z.add("NULL");
            x.add(z);
            for (int i = 1; i <= N; ++i) {
                String s = RS.colAsString(resultSet, i);
                z.add(s);
            }
        }
        return x;
    }

    static int[] pass1(ResultSetMetaData rsmd, List<List<String>> rows) throws SQLException {
        int[] col = new int[rsmd.getColumnCount() + 1];
        col[0] = -1;
        for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
            int w;
            col[i] = w = rsmd.getColumnLabel(i).length();
        }
        for (List<String> x : rows) {
            int i = 0;
            for (String z : x) {
                if (z == null) continue;
                if (z.length() > col[i]) {
                    col[i] = z.length();
                }
                ++i;
            }
        }
        return col;
    }

    static String colAsString(ResultSet resultSet, int i) throws SQLException {
        ResultSetMetaData rsmd = resultSet.getMetaData();
        String str2 = null;
        switch (rsmd.getColumnType(i)) {
            case -1: 
            case 1: 
            case 12: {
                str2 = "\"" + resultSet.getString(i) + "\"";
                break;
            }
            case 4: {
                str2 = Integer.toString(resultSet.getInt(i));
                break;
            }
            case 8: {
                str2 = Double.toString(resultSet.getDouble(i));
                break;
            }
            case 6: {
                str2 = Float.toString(resultSet.getFloat(i));
                break;
            }
            case 2004: {
                byte[] b2 = resultSet.getBytes(1);
                try {
                    str2 = new String(b2, 0, b2.length, "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    ex.printStackTrace();
                }
                break;
            }
            default: {
                str2 = resultSet.getString(i);
            }
        }
        if (resultSet.wasNull()) {
            str2 = "<null>";
        }
        return str2;
    }

    static void fmt(PrintStream out, String s, int w) {
        RS.fmt(out, s, w, ' ');
    }

    static void fmt(PrintStream out, String s, int w, char pad) {
        if (s == null) {
            s = "NULL";
        }
        for (int i = 0; i < w - s.length(); ++i) {
            out.print(pad);
        }
        out.print(s);
    }
}

