/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.file;

import com.hp.hpl.jena.tdb.base.block.Block;
import com.hp.hpl.jena.tdb.base.file.BlockAccessBase;
import com.hp.hpl.jena.tdb.base.file.FileException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BlockAccessMapped
extends BlockAccessBase {
    private static Logger log = LoggerFactory.getLogger(BlockAccessMapped.class);
    private final int GrowthFactor = 2;
    private final int SegmentSize = 0x800000;
    private final int blocksPerSegment;
    private int initialNumSegements = 1;
    private MappedByteBuffer[] segments = new MappedByteBuffer[this.initialNumSegements];
    private int segmentDirtyCount = 0;
    private boolean[] segmentDirty = new boolean[this.initialNumSegements];

    public BlockAccessMapped(String filename, int blockSize) {
        super(filename, blockSize);
        this.blocksPerSegment = 0x800000 / blockSize;
        if (0x800000 % blockSize != 0) {
            this.getLog().warn(String.format("%s: Segement size(%d) not a multiple of blocksize (%d)", filename, 0x800000, blockSize));
        }
        for (int i = 0; i < this.initialNumSegements; ++i) {
            this.segmentDirty[i] = false;
        }
        this.segmentDirtyCount = 0;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug(String.format("Segment:%d  BlockSize=%d  blocksPerSegment=%d", 0x800000, blockSize, this.blocksPerSegment));
        }
    }

    @Override
    public Block allocate(int blkSize) {
        if (blkSize > 0 && blkSize != this.blockSize) {
            throw new FileException("Fixed blocksize only: request= " + blkSize + "fixed size=" + this.blockSize);
        }
        int id = this.allocateId();
        ByteBuffer bb = this.getByteBuffer(id);
        bb.position(0);
        Block block = new Block(id, bb);
        return block;
    }

    @Override
    public Block read(long id) {
        this.check(id);
        this.checkIfClosed();
        ByteBuffer bb = this.getByteBuffer(id);
        bb.position(0);
        Block block = new Block(id, bb);
        return block;
    }

    @Override
    public void write(Block block) {
        this.write(block, CopyContents.NoCopy);
    }

    @Override
    public void overwrite(Block block) {
        this.overwriteNotification(block);
        this.write(block, CopyContents.Overwrite);
    }

    private void write(Block block, CopyContents copyContents) {
        this.check(block);
        this.checkIfClosed();
        int id = block.getId().intValue();
        if (copyContents == CopyContents.Overwrite) {
            ByteBuffer bbDst = this.getByteBuffer(id);
            bbDst.position(0);
            ByteBuffer bbSrc = block.getByteBuffer();
            bbSrc.rewind();
            bbDst.put(bbSrc);
        }
        this.segmentDirty[this.segment((int)id)] = true;
        this.writeNotification(block);
    }

    @Override
    public void sync() {
        this.checkIfClosed();
        this.force();
    }

    private ByteBuffer getByteBuffer(long _id) {
        int id = (int)_id;
        int seg = this.segment(id);
        int segOff = this.byteOffset(id);
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace(String.format("%d => [%d, %d]", id, seg, segOff));
        }
        BlockAccessMapped blockAccessMapped = this;
        synchronized (blockAccessMapped) {
            try {
                MappedByteBuffer segBuffer = this.allocSegment(seg);
                ((ByteBuffer)segBuffer).position(segOff);
                ((ByteBuffer)segBuffer).limit(segOff + this.blockSize);
                ByteBuffer dst = ((ByteBuffer)segBuffer).slice();
                ((ByteBuffer)segBuffer).limit(segBuffer.capacity());
                this.numFileBlocks = Math.max(this.numFileBlocks, (long)(id + 1));
                return dst;
            }
            catch (IllegalArgumentException ex) {
                log.error("Id: " + id);
                log.error("Seg=" + seg);
                log.error("Segoff=" + segOff);
                log.error(ex.getMessage(), ex);
                throw ex;
            }
        }
    }

    private final int segment(int id) {
        return id / this.blocksPerSegment;
    }

    private final int byteOffset(int id) {
        return id % this.blocksPerSegment * this.blockSize;
    }

    private final long fileLocation(long segmentNumber) {
        return segmentNumber * 0x800000L;
    }

    private MappedByteBuffer allocSegment(int seg) {
        if (seg < 0) {
            this.getLog().error("Segment negative: " + seg);
            throw new FileException("Negative segment: " + seg);
        }
        while (seg >= this.segments.length) {
            MappedByteBuffer[] segments2 = new MappedByteBuffer[2 * this.segments.length];
            System.arraycopy(this.segments, 0, segments2, 0, this.segments.length);
            boolean[] segmentDirty2 = new boolean[2 * this.segmentDirty.length];
            System.arraycopy(this.segmentDirty, 0, segmentDirty2, 0, this.segmentDirty.length);
            this.segmentDirty = segmentDirty2;
            this.segments = segments2;
        }
        long offset = this.fileLocation(seg);
        if (offset < 0L) {
            this.getLog().error("Segment offset gone negative: " + seg);
            throw new FileException("Negative segment offset: " + seg);
        }
        MappedByteBuffer segBuffer = this.segments[seg];
        if (segBuffer == null) {
            try {
                segBuffer = this.file.channel().map(FileChannel.MapMode.READ_WRITE, offset, 0x800000L);
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug(String.format("Segment: %d", seg));
                }
                this.segments[seg] = segBuffer;
            }
            catch (IOException ex) {
                if (ex.getCause() instanceof OutOfMemoryError) {
                    throw new FileException("BlockMgrMapped.segmentAllocate: Segment = " + seg + " : Offset = " + offset);
                }
                throw new FileException("BlockMgrMapped.segmentAllocate: Segment = " + seg, ex);
            }
        }
        return segBuffer;
    }

    private synchronized void flushDirtySegments() {
        super.force();
        for (int i = 0; i < this.segments.length; ++i) {
            if (this.segments[i] == null || !this.segmentDirty[i]) continue;
            this.segments[i].force();
            this.segmentDirty[i] = false;
            --this.segmentDirtyCount;
        }
    }

    @Override
    protected void _close() {
        this.force();
        Arrays.fill(this.segments, null);
        Arrays.fill(this.segmentDirty, false);
        this.segmentDirtyCount = 0;
    }

    @Override
    protected void force() {
        this.flushDirtySegments();
        super.force();
    }

    @Override
    protected Logger getLog() {
        return log;
    }

    public String toString() {
        return super.getLabel();
    }

    private static enum CopyContents {
        Overwrite,
        NoCopy;

    }
}

