/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store.bulkloader2;

import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.block.BlockMgrFactory;
import com.hp.hpl.jena.tdb.base.file.FileSet;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTree;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTreeParams;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTreeRewriter;
import com.hp.hpl.jena.tdb.store.bulkloader2.RecordsFromInput;
import com.hp.hpl.jena.tdb.sys.Names;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.ColumnMap;
import org.apache.jena.atlas.logging.Log;
import tdb.cmdline.CmdTDB;

public class CmdIndexBuild {
    public static void main(String ... argv) {
        int dftValueLength;
        int dftKeyLength;
        String primaryOrder;
        CmdTDB.init();
        if (argv.length != 3) {
            System.err.println("Usage: Location Index dataFile");
            System.exit(1);
        }
        String locationStr = argv[0];
        String indexName = argv[1];
        if (!Arrays.asList(Names.tripleIndexes).contains(indexName) && !Arrays.asList(Names.quadIndexes).contains(indexName)) {
            System.err.println("Index name not recognized: " + indexName);
            System.exit(1);
        }
        String dataFile = argv[2];
        Location location = new Location(locationStr);
        InputStream input = IO.openFile(dataFile);
        int keyLength = 8 * indexName.length();
        boolean valueLength = false;
        String primary = indexName;
        int tupleLength = indexName.length();
        if (tupleLength == 3) {
            primaryOrder = "SPO";
            dftKeyLength = 24;
            dftValueLength = 0;
        } else if (tupleLength == 4) {
            primaryOrder = "GSPO";
            dftKeyLength = 32;
            dftValueLength = 0;
        } else {
            throw new AtlasException("Index name: " + indexName);
        }
        ColumnMap colMap = new ColumnMap(primaryOrder, indexName);
        int readCacheSize = 10;
        int writeCacheSize = 100;
        int blockSize = 8192;
        RecordFactory recordFactory = new RecordFactory(dftKeyLength, dftValueLength);
        int order = BPlusTreeParams.calcOrder(blockSize, recordFactory);
        BPlusTreeParams bptParams = new BPlusTreeParams(order, recordFactory);
        int blockSizeNodes = blockSize;
        int blockSizeRecords = blockSize;
        FileSet destination = new FileSet(location, indexName);
        BlockMgr blkMgrNodes = BlockMgrFactory.create(destination, "idn", blockSizeNodes, readCacheSize, writeCacheSize);
        BlockMgr blkMgrRecords = BlockMgrFactory.create(destination, "dat", blockSizeRecords, readCacheSize, writeCacheSize);
        int rowBlock = 1000;
        RecordsFromInput iter = new RecordsFromInput(input, tupleLength, colMap, rowBlock);
        BPlusTree bpt2 = BPlusTreeRewriter.packIntoBPlusTree(iter, bptParams, recordFactory, blkMgrNodes, blkMgrRecords);
        bpt2.close();
    }

    static {
        Log.setLog4j();
    }
}

