/*
 * Decompiled with CFR 0.152.
 */
package org.vivoweb.tools;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sdb.SDBFactory;
import com.hp.hpl.jena.sdb.Store;
import com.hp.hpl.jena.sdb.StoreDesc;
import com.hp.hpl.jena.sdb.layout2.ValueType;
import com.hp.hpl.jena.sdb.sql.SDBExceptionSQL;
import com.hp.hpl.jena.sdb.store.DatabaseType;
import com.hp.hpl.jena.sdb.store.LayoutType;
import com.hp.hpl.jena.sdb.util.StoreUtils;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.TDBFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.vivoweb.tools.Utils;

public class ApplicationStores {
    private final Model applicationModel;
    private Dataset contentDataset;
    private Dataset configurationDataset;
    private Connection contentConnection;
    private StoreDesc contentStoreDesc;
    private boolean configured = false;
    static final String DEFAULT_DRIVER_CLASS = "com.mysql.jdbc.Driver";
    static final String DEFAULT_LAYOUT = "layout2/hash";
    static final String DEFAULT_TYPE = "MySQL";
    static final String PROPERTY_DB_URL = "VitroConnection.DataSource.url";
    static final String PROPERTY_DB_USERNAME = "VitroConnection.DataSource.username";
    static final String PROPERTY_DB_PASSWORD = "VitroConnection.DataSource.password";
    static final String PROPERTY_DB_DRIVER_CLASS_NAME = "VitroConnection.DataSource.driver";
    static final String PROPERTY_DB_SDB_LAYOUT = "VitroConnection.DataSource.sdb.layout";
    static final String PROPERTY_DB_TYPE = "VitroConnection.DataSource.dbtype";

    public ApplicationStores(String homeDir) {
        File config = Utils.resolveFile(homeDir, "config/applicationSetup.n3");
        try {
            FileInputStream in = new FileInputStream(config);
            this.applicationModel = ModelFactory.createDefaultModel();
            this.applicationModel.read(in, null, "N3");
            ((InputStream)in).close();
        }
        catch (FileNotFoundException e2) {
            throw new RuntimeException("Application setup not found");
        }
        catch (IOException e3) {
            throw new RuntimeException("Error closing config");
        }
        try {
            Resource contentSource = this.getObjectFor("http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationSetup#hasContentTripleSource");
            Resource configurationSource = this.getObjectFor("http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationSetup#hasConfigurationTripleSource");
            if (this.isType(contentSource, "java:edu.cornell.mannlib.vitro.webapp.triplesource.impl.sdb.ContentTripleSourceSDB")) {
                Properties props = new Properties();
                try {
                    FileInputStream in = new FileInputStream(Utils.resolveFile(homeDir, "runtime.properties"));
                    props.load(in);
                    ((InputStream)in).close();
                }
                catch (FileNotFoundException f) {
                    throw new RuntimeException("Unable to find properties");
                }
                catch (IOException e4) {
                    throw new RuntimeException("Unable to load properties", e4);
                }
                this.contentConnection = this.makeConnection(props);
                this.contentStoreDesc = this.makeStoreDesc(props);
                Store store = SDBFactory.connectStore(this.contentConnection, this.contentStoreDesc);
                if (store == null) {
                    throw new RuntimeException("Unable to connect to SDB content triple store");
                }
                if (!StoreUtils.isFormatted(store)) {
                    store.getTableFormatter().create();
                    store.getTableFormatter().truncate();
                }
                this.contentDataset = SDBFactory.connectDataset(store);
                if (this.contentDataset == null) {
                    throw new RuntimeException("Unable to connect to SDB content dataset");
                }
            } else if (this.isType(contentSource, "java:edu.cornell.mannlib.vitro.webapp.triplesource.impl.tdb.ContentTripleSourceTDB")) {
                com.hp.hpl.jena.rdf.model.Statement stmt = contentSource.getProperty(this.applicationModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationSetup#hasTdbDirectory"));
                String tdbDirectory = null;
                if (stmt != null) {
                    tdbDirectory = stmt.getObject().asLiteral().getString();
                }
                if (StringUtils.isEmpty(tdbDirectory)) {
                    throw new RuntimeException("Content Source TDB missing directory property");
                }
                File contentFile = Utils.resolveFile(homeDir, tdbDirectory);
                if (!contentFile.exists()) {
                    if (!contentFile.mkdirs()) {
                        throw new RuntimeException("Unable to create content TDB source " + contentFile.getAbsolutePath());
                    }
                } else if (!contentFile.isDirectory()) {
                    throw new RuntimeException("Content triple source exists but is not a directory " + contentFile.getAbsolutePath());
                }
                this.contentDataset = TDBFactory.createDataset(contentFile.getAbsolutePath());
                if (this.contentDataset == null) {
                    throw new RuntimeException("Unable to open TDB content triple store");
                }
            }
            if (this.isType(configurationSource, "java:edu.cornell.mannlib.vitro.webapp.triplesource.impl.tdb.ConfigurationTripleSourceTDB")) {
                File configFile = Utils.resolveFile(homeDir, "tdbModels");
                if (!configFile.exists()) {
                    if (!configFile.mkdirs()) {
                        throw new RuntimeException("Unable to create configuration source " + configFile.getAbsolutePath());
                    }
                } else if (!configFile.isDirectory()) {
                    throw new RuntimeException("Configuration triple source exists but is not a directory " + configFile.getAbsolutePath());
                }
                this.configurationDataset = TDBFactory.createDataset(configFile.getAbsolutePath());
                if (this.configurationDataset == null) {
                    throw new RuntimeException("Unable to open TDB configuration triple store");
                }
            }
            this.configured = true;
        }
        catch (SQLException e5) {
            throw new RuntimeException("SQL Exception");
        }
        finally {
            if (!this.configured) {
                this.close();
            }
        }
    }

    public void readConfiguration(File input) {
        if (this.configurationDataset != null) {
            try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(input));){
                RDFDataMgr.read(this.configurationDataset, (InputStream)inputStream, Lang.TRIG);
                TDB.sync(this.configurationDataset);
            }
            catch (FileNotFoundException e2) {
                throw new RuntimeException("Unable to find configuration dump");
            }
            catch (IOException e3) {
                throw new RuntimeException("Unable to read configuration dump", e3);
            }
        }
    }

    public void readContent(File input) {
        if (this.contentDataset != null) {
            try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(input));){
                if (this.contentConnection != null) {
                    this.contentConnection.setAutoCommit(false);
                    RDFDataMgr.read(this.contentDataset, (InputStream)inputStream, Lang.TRIG);
                    this.contentConnection.commit();
                } else {
                    RDFDataMgr.read(this.contentDataset, (InputStream)inputStream, Lang.TRIG);
                    TDB.sync(this.contentDataset);
                }
            }
            catch (FileNotFoundException e2) {
                throw new RuntimeException("Unable to find content dump");
            }
            catch (IOException e3) {
                throw new RuntimeException("Unable to read content dump", e3);
            }
        }
    }

    public void writeConfiguration(File output) {
        if (this.configurationDataset != null) {
            try {
                BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(output, false));
                RDFDataMgr.write((OutputStream)outputStream, this.configurationDataset, RDFFormat.TRIG_BLOCKS);
                ((OutputStream)outputStream).close();
            }
            catch (FileNotFoundException e2) {
                throw new RuntimeException("Unable to write configuration dump (dir error)");
            }
            catch (IOException e3) {
                throw new RuntimeException("Unable to write configuration dump", e3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeContent(File output) {
        if (this.contentDataset != null) {
            try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(output, false));){
                if (LayoutType.LayoutTripleNodesHash.equals(this.contentStoreDesc.getLayout()) || LayoutType.LayoutTripleNodesIndex.equals(this.contentStoreDesc.getLayout())) {
                    if (DatabaseType.MySQL.equals(this.contentStoreDesc.getDbType()) || DatabaseType.PostgreSQL.equals(this.contentStoreDesc.getDbType())) {
                        long offset = 0L;
                        long limit = 10000L;
                        Dataset blankQuads = DatasetFactory.createMem();
                        while (this.writeContentSQL(outputStream, blankQuads, offset, limit)) {
                            offset += limit;
                        }
                        if (blankQuads.asDatasetGraph().size() > 0L) {
                            RDFDataMgr.write((OutputStream)outputStream, blankQuads, RDFFormat.TRIG_BLOCKS);
                        }
                    } else {
                        RDFDataMgr.write((OutputStream)outputStream, this.contentDataset, RDFFormat.TRIG_BLOCKS);
                    }
                } else {
                    RDFDataMgr.write((OutputStream)outputStream, this.contentDataset, RDFFormat.TRIG_BLOCKS);
                }
            }
            catch (FileNotFoundException e2) {
                throw new RuntimeException("Unable to write content dump (dir error)");
            }
            catch (IOException e3) {
                throw new RuntimeException("Unable to write content dump", e3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeContentSQL(OutputStream outputStream, Dataset blankQuads, long offset, long limit) {
        Dataset quads = DatasetFactory.createMem();
        try {
            Statement stmt = this.contentConnection.createStatement();
            try (ResultSet rs = stmt.executeQuery("SELECT \nN1.lex AS s_lex, N1.lang AS s_lang, N1.datatype AS s_datatype, N1.type AS s_type,\nN2.lex AS p_lex, N2.lang AS p_lang, N2.datatype AS p_datatype, N2.type AS p_type,\nN3.lex AS o_lex, N3.lang AS o_lang, N3.datatype AS o_datatype, N3.type AS o_type,\nN4.lex AS g_lex, N4.lang AS g_lang, N4.datatype AS g_datatype, N4.type AS g_type \nFROM\n(SELECT g,s,p,o FROM Quads ORDER BY g,s,p,o " + (limit > 0L ? "LIMIT " + limit : "") + (offset > 0L ? " OFFSET " + offset : "") + ") Q\n" + (LayoutType.LayoutTripleNodesHash.equals(this.contentStoreDesc.getLayout()) ? "LEFT OUTER JOIN Nodes AS N1 ON ( Q.s = N1.hash ) LEFT OUTER JOIN Nodes AS N2 ON ( Q.p = N2.hash ) LEFT OUTER JOIN Nodes AS N3 ON ( Q.o = N3.hash ) LEFT OUTER JOIN Nodes AS N4 ON ( Q.g = N4.hash ) " : "LEFT OUTER JOIN Nodes AS N1 ON ( Q.s = N1.id ) LEFT OUTER JOIN Nodes AS N2 ON ( Q.p = N2.id ) LEFT OUTER JOIN Nodes AS N3 ON ( Q.o = N3.id ) LEFT OUTER JOIN Nodes AS N4 ON ( Q.g = N4.id ) "));){
                while (rs.next()) {
                    Node subjectNode = ApplicationStores.makeNode(rs.getString("s_lex"), rs.getString("s_datatype"), rs.getString("s_lang"), ValueType.lookup(rs.getInt("s_type")));
                    Node predicateNode = ApplicationStores.makeNode(rs.getString("p_lex"), rs.getString("p_datatype"), rs.getString("p_lang"), ValueType.lookup(rs.getInt("p_type")));
                    Node objectNode = ApplicationStores.makeNode(rs.getString("o_lex"), rs.getString("o_datatype"), rs.getString("o_lang"), ValueType.lookup(rs.getInt("o_type")));
                    Node graphNode = ApplicationStores.makeNode(rs.getString("g_lex"), rs.getString("g_datatype"), rs.getString("g_lang"), ValueType.lookup(rs.getInt("g_type")));
                    if (subjectNode.isBlank() || predicateNode.isBlank() || objectNode.isBlank()) {
                        blankQuads.asDatasetGraph().add(Quad.create(graphNode, Triple.create(subjectNode, predicateNode, objectNode)));
                        continue;
                    }
                    quads.asDatasetGraph().add(Quad.create(graphNode, Triple.create(subjectNode, predicateNode, objectNode)));
                }
            }
            if (quads.asDatasetGraph().size() > 0L) {
                RDFDataMgr.write(outputStream, quads, RDFFormat.TRIG_BLOCKS);
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException sqle) {
            throw new RuntimeException("Unable to retrieve triples", sqle);
        }
        return false;
    }

    private static Node makeNode(String lex, String datatype, String lang, ValueType vType) {
        switch (vType) {
            case BNODE: {
                return NodeFactory.createAnon(new AnonId(lex));
            }
            case URI: {
                return NodeFactory.createURI(lex);
            }
            case STRING: {
                return NodeFactory.createLiteral(lex, lang, false);
            }
            case XSDSTRING: {
                return NodeFactory.createLiteral(lex, XSDDatatype.XSDstring);
            }
            case INTEGER: {
                return NodeFactory.createLiteral(lex, XSDDatatype.XSDinteger);
            }
            case DOUBLE: {
                return NodeFactory.createLiteral(lex, XSDDatatype.XSDdouble);
            }
            case DATETIME: {
                return NodeFactory.createLiteral(lex, XSDDatatype.XSDdateTime);
            }
            case OTHER: {
                RDFDatatype dt = TypeMapper.getInstance().getSafeTypeByName(datatype);
                return NodeFactory.createLiteral(lex, dt);
            }
        }
        return NodeFactory.createLiteral("UNRECOGNIZED");
    }

    public boolean isEmpty() {
        boolean empty = true;
        try {
            if (this.configurationDataset != null) {
                empty &= this.configurationDataset.asDatasetGraph().isEmpty();
            }
        }
        catch (SDBExceptionSQL sDBExceptionSQL) {
            // empty catch block
        }
        try {
            if (this.contentDataset != null) {
                empty &= this.contentDataset.asDatasetGraph().isEmpty();
            }
        }
        catch (SDBExceptionSQL sDBExceptionSQL) {
            // empty catch block
        }
        return empty;
    }

    public boolean validateFiles(File configurationDump, File contentDump) {
        if (this.configurationDataset != null && !configurationDump.exists()) {
            return false;
        }
        return this.contentDataset == null || contentDump.exists();
    }

    public void close() {
        if (this.configurationDataset != null) {
            this.configurationDataset.close();
        }
        if (this.contentDataset != null) {
            this.contentDataset.close();
        }
        TDB.closedown();
    }

    private boolean isType(Resource resource, String type) {
        return resource.hasProperty(RDF.type, this.applicationModel.createResource(type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource getObjectFor(String property) {
        try (NodeIterator iter = this.applicationModel.listObjectsOfProperty(this.applicationModel.createProperty(property));){
            while (iter.hasNext()) {
                RDFNode node = iter.next();
                if (node == null || !node.isResource()) continue;
                Resource resource = node.asResource();
                return resource;
            }
        }
        return null;
    }

    private StoreDesc makeStoreDesc(Properties props) {
        String layoutStr = props.getProperty(PROPERTY_DB_SDB_LAYOUT, DEFAULT_LAYOUT).trim();
        String dbtypeStr = props.getProperty(PROPERTY_DB_TYPE, DEFAULT_TYPE).trim();
        return new StoreDesc(LayoutType.fetch(layoutStr), DatabaseType.fetch(dbtypeStr));
    }

    private Connection makeConnection(Properties props) {
        try {
            Class.forName(props.getProperty(PROPERTY_DB_DRIVER_CLASS_NAME, DEFAULT_DRIVER_CLASS).trim());
            String url = props.getProperty(PROPERTY_DB_URL).trim();
            String user = props.getProperty(PROPERTY_DB_USERNAME).trim();
            String pass = props.getProperty(PROPERTY_DB_PASSWORD).trim();
            String dbtypeStr = props.getProperty(PROPERTY_DB_TYPE, DEFAULT_TYPE).trim();
            if (DEFAULT_TYPE.equals(dbtypeStr) && !url.contains("?")) {
                url = url + "?useUnicode=yes&characterEncoding=utf8";
            }
            return DriverManager.getConnection(url, user, pass);
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException("Unable to find database driver");
        }
        catch (SQLException e3) {
            throw new RuntimeException("Unable to create JDBC connection", e3);
        }
    }
}

