/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.rdf.model.Alt;
import com.hp.hpl.jena.rdf.model.Bag;
import com.hp.hpl.jena.rdf.model.Container;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceF;
import com.hp.hpl.jena.rdf.model.Seq;
import com.hp.hpl.jena.rdf.model.SeqIndexBoundsException;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.impl.ContainerImpl;
import com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.rdf.model.impl.NodeIteratorFactory;
import com.hp.hpl.jena.rdf.model.impl.SeqNodeIteratorFactoryImpl;
import com.hp.hpl.jena.vocabulary.RDF;

public class SeqImpl
extends ContainerImpl
implements Seq {
    public static final Implementation factory = new Implementation(){

        @Override
        public boolean canWrap(Node n, EnhGraph eg) {
            return true;
        }

        @Override
        public EnhNode wrap(Node n, EnhGraph eg) {
            return new SeqImpl(n, eg);
        }
    };
    static NodeIteratorFactory seqIteratorFactory = new SeqNodeIteratorFactoryImpl();

    public SeqImpl(ModelCom model) {
        super(model);
    }

    public SeqImpl(String uri, ModelCom model) {
        super(uri, model);
    }

    public SeqImpl(Resource r, ModelCom m) {
        super(r, m);
    }

    public SeqImpl(Node n, EnhGraph g) {
        super(n, g);
    }

    @Override
    public Resource getResource(int index) {
        return this.getRequiredProperty(RDF.li(index)).getResource();
    }

    @Override
    public Literal getLiteral(int index) {
        return this.getRequiredProperty(RDF.li(index)).getLiteral();
    }

    @Override
    public RDFNode getObject(int index) {
        return this.getRequiredProperty(RDF.li(index)).getObject();
    }

    @Override
    public boolean getBoolean(int index) {
        this.checkIndex(index);
        return this.getRequiredProperty(RDF.li(index)).getBoolean();
    }

    @Override
    public byte getByte(int index) {
        this.checkIndex(index);
        return this.getRequiredProperty(RDF.li(index)).getByte();
    }

    @Override
    public short getShort(int index) {
        this.checkIndex(index);
        return this.getRequiredProperty(RDF.li(index)).getShort();
    }

    @Override
    public int getInt(int index) {
        this.checkIndex(index);
        return this.getRequiredProperty(RDF.li(index)).getInt();
    }

    @Override
    public long getLong(int index) {
        this.checkIndex(index);
        return this.getRequiredProperty(RDF.li(index)).getLong();
    }

    @Override
    public char getChar(int index) {
        this.checkIndex(index);
        return this.getRequiredProperty(RDF.li(index)).getChar();
    }

    @Override
    public float getFloat(int index) {
        this.checkIndex(index);
        return this.getRequiredProperty(RDF.li(index)).getFloat();
    }

    @Override
    public double getDouble(int index) {
        this.checkIndex(index);
        return this.getRequiredProperty(RDF.li(index)).getDouble();
    }

    @Override
    public String getString(int index) {
        this.checkIndex(index);
        return this.getRequiredProperty(RDF.li(index)).getString();
    }

    @Override
    public String getLanguage(int index) {
        this.checkIndex(index);
        return this.getRequiredProperty(RDF.li(index)).getLanguage();
    }

    @Override
    @Deprecated
    public Resource getResource(int index, ResourceF f) {
        return this.getRequiredProperty(RDF.li(index)).getResource(f);
    }

    @Override
    public Bag getBag(int index) {
        this.checkIndex(index);
        return this.getRequiredProperty(RDF.li(index)).getBag();
    }

    @Override
    public Alt getAlt(int index) {
        this.checkIndex(index);
        return this.getRequiredProperty(RDF.li(index)).getAlt();
    }

    @Override
    public Seq getSeq(int index) {
        this.checkIndex(index);
        return this.getRequiredProperty(RDF.li(index)).getSeq();
    }

    @Override
    public Seq set(int index, RDFNode o) {
        this.checkIndex(index);
        this.getRequiredProperty(RDF.li(index)).changeObject(o);
        return this;
    }

    @Override
    public Seq set(int index, boolean o) {
        this.checkIndex(index);
        this.getRequiredProperty(RDF.li(index)).changeLiteralObject(o);
        return this;
    }

    @Override
    public Seq set(int index, long o) {
        this.checkIndex(index);
        this.getRequiredProperty(RDF.li(index)).changeLiteralObject(o);
        return this;
    }

    @Override
    public Seq set(int index, float o) {
        this.checkIndex(index);
        this.getRequiredProperty(RDF.li(index)).changeLiteralObject(o);
        return this;
    }

    @Override
    public Seq set(int index, double o) {
        this.checkIndex(index);
        this.getRequiredProperty(RDF.li(index)).changeLiteralObject(o);
        return this;
    }

    @Override
    public Seq set(int index, char o) {
        this.checkIndex(index);
        this.getRequiredProperty(RDF.li(index)).changeLiteralObject(o);
        return this;
    }

    @Override
    public Seq set(int index, String o) {
        this.checkIndex(index);
        this.getRequiredProperty(RDF.li(index)).changeObject(o);
        return this;
    }

    @Override
    public Seq set(int index, String o, String l) {
        this.checkIndex(index);
        this.getRequiredProperty(RDF.li(index)).changeObject(o, l);
        return this;
    }

    @Override
    public Seq set(int index, Object o) {
        this.checkIndex(index);
        Statement s = this.getRequiredProperty(RDF.li(index));
        Model m = s.getModel();
        Statement s2 = m.createLiteralStatement(s.getSubject(), s.getPredicate(), o);
        s.getModel().remove(s);
        s.getModel().add(s2);
        return this;
    }

    @Override
    public Seq add(int index, boolean o) {
        return this.add(index, String.valueOf(o));
    }

    @Override
    public Seq add(int index, long o) {
        return this.add(index, String.valueOf(o));
    }

    @Override
    public Seq add(int index, char o) {
        return this.add(index, String.valueOf(o));
    }

    @Override
    public Seq add(int index, float o) {
        return this.add(index, String.valueOf(o));
    }

    @Override
    public Seq add(int index, double o) {
        return this.add(index, String.valueOf(o));
    }

    @Override
    public Seq add(int index, Object o) {
        return this.add(index, String.valueOf(o));
    }

    @Override
    public Seq add(int index, String o) {
        return this.add(index, o, "");
    }

    @Override
    public Seq add(int index, String o, String l) {
        return this.add(index, this.literal(o, l));
    }

    @Override
    public Seq add(int index, RDFNode o) {
        int size = this.size();
        this.checkIndex(index, size + 1);
        this.shiftUp(index, size);
        this.addProperty(RDF.li(index), o);
        return this;
    }

    @Override
    public NodeIterator iterator() {
        return this.listContainerMembers(seqIteratorFactory);
    }

    @Override
    public Container remove(Statement s) {
        this.getModel().remove(s);
        this.shiftDown(s.getPredicate().getOrdinal() + 1, this.size() + 1);
        return this;
    }

    @Override
    public Seq remove(int index) {
        this.getRequiredProperty(RDF.li(index)).remove();
        this.shiftDown(index + 1, this.size() + 1);
        return this;
    }

    @Override
    public Container remove(int index, RDFNode o) {
        return this.remove(this.getModel().createStatement((Resource)this, RDF.li(index), o).remove());
    }

    @Override
    public int indexOf(RDFNode o) {
        return this.containerIndexOf(o);
    }

    @Override
    public int indexOf(boolean o) {
        return this.indexOf(String.valueOf(o));
    }

    @Override
    public int indexOf(long o) {
        return this.indexOf(String.valueOf(o));
    }

    @Override
    public int indexOf(char o) {
        return this.indexOf(String.valueOf(o));
    }

    @Override
    public int indexOf(float o) {
        return this.indexOf(String.valueOf(o));
    }

    @Override
    public int indexOf(double o) {
        return this.indexOf(String.valueOf(o));
    }

    @Override
    public int indexOf(Object o) {
        return this.indexOf(String.valueOf(o));
    }

    @Override
    public int indexOf(String o) {
        return this.indexOf(o, "");
    }

    @Override
    public int indexOf(String o, String l) {
        return this.indexOf(this.literal(o, l));
    }

    private Literal literal(String s, String lang) {
        return new LiteralImpl(NodeFactory.createLiteral(s, lang, false), this.getModelCom());
    }

    protected void shiftUp(int start, int finish) {
        Statement stmt = null;
        for (int i = finish; i >= start; --i) {
            stmt = this.getRequiredProperty(RDF.li(i));
            this.getModel().remove(stmt);
            this.addProperty(RDF.li(i + 1), stmt.getObject());
        }
    }

    protected void shiftDown(int start, int finish) {
        for (int i = start; i <= finish; ++i) {
            Statement stmt = this.getRequiredProperty(RDF.li(i));
            stmt.remove();
            this.addProperty(RDF.li(i - 1), stmt.getObject());
        }
    }

    protected void checkIndex(int index) {
        this.checkIndex(index, this.size());
    }

    protected void checkIndex(int index, int max2) {
        if (1 > index || index > max2) {
            throw new SeqIndexBoundsException(max2, index);
        }
    }
}

