/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.layout2.hash;

import com.hp.hpl.jena.sdb.SDBException;
import com.hp.hpl.jena.sdb.layout2.FmtLayout2;
import com.hp.hpl.jena.sdb.layout2.TableDescNodes;
import com.hp.hpl.jena.sdb.layout2.TableDescQuads;
import com.hp.hpl.jena.sdb.layout2.TableDescTriples;
import com.hp.hpl.jena.sdb.layout2.TablePrefixes;
import com.hp.hpl.jena.sdb.sql.MySQLEngineType;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.sql.SDBExceptionSQL;
import com.hp.hpl.jena.sdb.sql.SQLUtils;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FmtLayout2HashMySQL
extends FmtLayout2 {
    private static Logger log = LoggerFactory.getLogger(FmtLayout2HashMySQL.class);
    protected MySQLEngineType engineType;

    public FmtLayout2HashMySQL(SDBConnection connection, MySQLEngineType tableType) {
        super(connection);
        this.engineType = tableType;
        if (this.engineType == null) {
            log.error("Engine type is null");
            throw new SDBException("Engine type is null");
        }
    }

    @Override
    protected void formatTableTriples() {
        this.dropTable(TableDescTriples.name());
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE " + TableDescTriples.name() + " (", "    s BIGINT  NOT NULL ,", "    p BIGINT  NOT NULL ,", "    o BIGINT  NOT NULL ,", "    PRIMARY KEY (s, p, o)", ") ENGINE=" + this.engineType.getEngineName()));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException formatting table '" + TableDescTriples.name() + "'", ex);
        }
    }

    @Override
    protected void formatTableQuads() {
        this.dropTable(TableDescQuads.name());
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE " + TableDescQuads.name() + " (", "    g BIGINT  NOT NULL ,", "    s BIGINT  NOT NULL ,", "    p BIGINT  NOT NULL ,", "    o BIGINT  NOT NULL ,", "    PRIMARY KEY (g, s, p, o)", ") ENGINE=" + this.engineType.getEngineName()));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException formatting table '" + TableDescTriples.name() + "'", ex);
        }
    }

    @Override
    protected String syntaxDropIndex(String indexName, String table) {
        return String.format("DROP INDEX %s ON %s", indexName, table);
    }

    @Override
    protected void formatTableNodes() {
        this.dropTable(TableDescNodes.name());
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE " + TableDescNodes.name() + " (", "   hash BIGINT NOT NULL DEFAULT 0,", "   lex LONGTEXT BINARY CHARACTER SET utf8 ,", "   lang VARCHAR(10) BINARY CHARACTER SET utf8 NOT NULL default '',", "   datatype VARCHAR(200) BINARY CHARACTER SET utf8 NOT NULL default '',", "   type int unsigned NOT NULL default '0',", "   PRIMARY KEY Hash  (hash)", ") ENGINE=" + this.engineType.getEngineName() + " DEFAULT CHARSET=utf8;"));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException formatting table '" + TableDescNodes.name() + "'", ex);
        }
    }

    @Override
    protected void formatTablePrefixes() {
        this.dropTable(TablePrefixes.name());
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE " + TablePrefixes.name() + " (", "    prefix VARCHAR(50) BINARY NOT NULL ,", "    uri VARCHAR(500) BINARY NOT NULL ,", "    PRIMARY KEY  (prefix)", ") ENGINE=" + this.engineType.getEngineName() + " DEFAULT CHARSET=utf8"));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException resetting table '" + TablePrefixes.name() + "'", ex);
        }
    }

    @Override
    protected void truncateTable(String tableName) {
        try {
            this.connection().exec("TRUNCATE " + tableName);
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException : Can't truncate table: " + tableName, ex);
        }
    }

    @Override
    protected void dropTable(String tableName) {
        try {
            this.connection().exec("DROP TABLE IF EXISTS " + tableName);
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException : Can't drop table: " + tableName, ex);
        }
    }
}

