/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.layout2.hash;

import com.hp.hpl.jena.sdb.layout2.FmtLayout2;
import com.hp.hpl.jena.sdb.layout2.TableDescNodes;
import com.hp.hpl.jena.sdb.layout2.TableDescQuads;
import com.hp.hpl.jena.sdb.layout2.TableDescTriples;
import com.hp.hpl.jena.sdb.layout2.TablePrefixes;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.sql.SDBExceptionSQL;
import com.hp.hpl.jena.sdb.sql.SQLUtils;
import java.sql.SQLException;

public class FmtLayout2HashOracle
extends FmtLayout2 {
    public FmtLayout2HashOracle(SDBConnection connection) {
        super(connection);
    }

    @Override
    protected void formatTableTriples() {
        this.dropTable(TableDescTriples.name());
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE " + TableDescTriples.name() + " (", "    s NUMBER(20) NOT NULL,", "    p NUMBER(20) NOT NULL,", "    o NUMBER(20) NOT NULL,", "    PRIMARY KEY (s, p, o)", ")"));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException formatting table '" + TableDescTriples.name() + "'", ex);
        }
    }

    @Override
    protected void formatTableQuads() {
        this.dropTable(TableDescQuads.name());
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE " + TableDescQuads.name() + " (", "    g NUMBER(20) NOT NULL,", "    s NUMBER(20) NOT NULL,", "    p NUMBER(20) NOT NULL,", "    o NUMBER(20) NOT NULL,", "    PRIMARY KEY (g, s, p, o)", ")"));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException formatting table '" + TableDescTriples.name() + "'", ex);
        }
    }

    @Override
    protected void formatTableNodes() {
        this.dropTable(TableDescNodes.name());
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE " + TableDescNodes.name() + " (", "   hash NUMBER(20) NOT NULL,", "   lex NCLOB,", "   lang NVARCHAR2(10),", "   datatype NVARCHAR2(200),", "   type integer  NOT NULL,", "   PRIMARY KEY (hash)", ")"));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException resetting table '" + TableDescNodes.name() + "'", ex);
        }
    }

    @Override
    protected void formatTablePrefixes() {
        this.dropTable(TablePrefixes.name());
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE " + TablePrefixes.name() + " (", "    prefix NVARCHAR2(50) ,", "    uri NVARCHAR2(500) ,", "    PRIMARY KEY  (prefix)", ")"));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException resetting table '" + TablePrefixes.name() + "'", ex);
        }
    }

    @Override
    protected void truncateTable(String tableName) {
        try {
            this.connection().exec("TRUNCATE TABLE " + tableName);
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException truncating table: " + tableName, ex);
        }
    }
}

