/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprNode;
import com.hp.hpl.jena.sparql.expr.ExprTransform;
import com.hp.hpl.jena.sparql.expr.ExprVisitor;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.VariableNotBoundException;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.graph.NodeTransform;
import org.apache.jena.atlas.io.IndentedWriter;

public class ExprVar
extends ExprNode {
    protected Var varNode = null;

    public ExprVar(String name) {
        this.varNode = Var.alloc(name);
    }

    public ExprVar(Node n) {
        if (!n.isVariable()) {
            throw new ARQInternalErrorException("Attempt to create a NodeVar from a non variable Node: " + n);
        }
        this.varNode = Var.alloc(n);
    }

    public ExprVar(Var v) {
        this.varNode = v;
    }

    @Override
    public NodeValue eval(Binding binding, FunctionEnv env) {
        return ExprVar.eval(this.varNode, binding, env);
    }

    static NodeValue eval(Var v, Binding binding, FunctionEnv env) {
        if (binding == null) {
            throw new VariableNotBoundException("Not bound: (no binding): " + v);
        }
        Node nv = binding.get(v);
        if (nv == null) {
            throw new VariableNotBoundException("Not bound: variable " + v);
        }
        return NodeValue.makeNode(nv);
    }

    @Override
    public Expr copySubstitute(Binding binding, boolean foldConstants) {
        Var v = this.varNode;
        if (binding == null || !binding.contains(this.varNode)) {
            return new ExprVar(v);
        }
        return this.eval(binding, null);
    }

    @Override
    public Expr applyNodeTransform(NodeTransform transform) {
        Node node = transform.convert(this.varNode);
        if (Var.isVar(node)) {
            return new ExprVar(Var.alloc(node));
        }
        return NodeValue.makeNode(node);
    }

    public Expr copy(Var v) {
        return new ExprVar(v);
    }

    @Override
    public void visit(ExprVisitor visitor) {
        visitor.visit(this);
    }

    public Expr apply(ExprTransform transform) {
        return transform.transform(this);
    }

    public void format(Query query2, IndentedWriter out) {
        out.print('?');
        out.print(this.varNode.getName());
    }

    @Override
    public int hashCode() {
        return this.varNode.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ExprVar)) {
            return false;
        }
        ExprVar nvar = (ExprVar)other;
        return this.getVarName().equals(nvar.getVarName());
    }

    @Override
    public boolean isVariable() {
        return true;
    }

    @Override
    public String getVarName() {
        return this.varNode.getName();
    }

    @Override
    public ExprVar getExprVar() {
        return this;
    }

    @Override
    public Var asVar() {
        return this.varNode;
    }

    public Node getAsNode() {
        return this.varNode;
    }

    public String toPrefixString() {
        return this.varNode.toString();
    }

    public String asSparqlExpr() {
        return this.varNode.toString();
    }

    @Override
    public String toString() {
        return this.varNode.toString();
    }
}

