/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.pfunction.library;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingFactory;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.pfunction.PropFuncArg;
import com.hp.hpl.jena.sparql.pfunction.library.ListBaseList;
import com.hp.hpl.jena.sparql.util.IterLib;
import com.hp.hpl.jena.sparql.util.NodeFactoryExtra;
import com.hp.hpl.jena.sparql.util.graph.GNode;
import com.hp.hpl.jena.sparql.util.graph.GraphList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class listIndex
extends ListBaseList {
    @Override
    protected QueryIterator execObjectList(Binding binding, Var listVar, Node predicate, List<Node> objectArgs, ExecutionContext execCxt) {
        if (objectArgs.size() != 2) {
            throw new ExprEvalException("ListIndex : object not a list of length 2");
        }
        Node indexNode = objectArgs.get(0);
        Node memberNode = objectArgs.get(1);
        Collection<Node> x = !Var.isVar(memberNode) ? GraphList.listFromMember(new GNode(execCxt.getActiveGraph(), memberNode)) : GraphList.findAllLists(execCxt.getActiveGraph());
        return super.allLists(binding, x, listVar, predicate, new PropFuncArg(objectArgs, null), execCxt);
    }

    @Override
    protected QueryIterator execOneList(Binding binding, Node listNode, Node predicate, List<Node> objectArgs, ExecutionContext execCxt) {
        if (Var.isVar(listNode)) {
            throw new ExprEvalException("ListIndex : subject not a list or variable bound to a list");
        }
        if (objectArgs.size() != 2) {
            throw new ExprEvalException("ListIndex : object not a list of length 2");
        }
        Node indexNode = objectArgs.get(0);
        Node memberNode = objectArgs.get(1);
        Graph graph = execCxt.getActiveGraph();
        if (Var.isVar(indexNode) && !Var.isVar(memberNode)) {
            return listIndex.findIndex(graph, binding, listNode, Var.alloc(indexNode), memberNode, execCxt);
        }
        if (!Var.isVar(indexNode) && Var.isVar(memberNode)) {
            return listIndex.getByIndex(graph, binding, listNode, indexNode, Var.alloc(memberNode), execCxt);
        }
        if (!Var.isVar(indexNode) && !Var.isVar(memberNode)) {
            return listIndex.testSlotValue(graph, binding, listNode, indexNode, memberNode, execCxt);
        }
        return listIndex.findIndexMember(graph, binding, listNode, Var.alloc(indexNode), Var.alloc(memberNode), execCxt);
    }

    private static QueryIterator getByIndex(Graph graph, Binding binding, Node listNode, Node indexNode, Var varMember, ExecutionContext execCxt) {
        int i = NodeFactoryExtra.nodeToInt(indexNode);
        if (i < 0) {
            return IterLib.noResults(execCxt);
        }
        Node n = GraphList.get(new GNode(graph, listNode), i);
        if (n == null) {
            return IterLib.noResults(execCxt);
        }
        return IterLib.oneResult(binding, varMember, n, execCxt);
    }

    private static QueryIterator testSlotValue(Graph graph, Binding binding, Node listNode, Node indexNode, Node memberNode, ExecutionContext execCxt) {
        int i = NodeFactoryExtra.nodeToInt(indexNode);
        if (i < 0) {
            return IterLib.noResults(execCxt);
        }
        Node n = GraphList.get(new GNode(graph, listNode), i);
        if (n == null) {
            return IterLib.noResults(execCxt);
        }
        if (n.equals(memberNode)) {
            return IterLib.result(binding, execCxt);
        }
        return IterLib.noResults(execCxt);
    }

    private static QueryIterator findIndex(Graph graph, Binding binding, Node listNode, Var var, Node member, ExecutionContext execCxt) {
        int i = GraphList.index(new GNode(graph, listNode), member);
        if (i < 0) {
            return IterLib.noResults(execCxt);
        }
        Node idx = NodeFactoryExtra.intToNode(i);
        return IterLib.oneResult(binding, var, idx, execCxt);
    }

    private static QueryIterator findIndexMember(Graph graph, Binding binding, Node listNode, Var varIndex, Var varMember, ExecutionContext execCxt) {
        List<Node> members = GraphList.members(new GNode(graph, listNode));
        ArrayList<BindingMap> bindings2 = new ArrayList<BindingMap>();
        for (int i = 0; i < members.size(); ++i) {
            Node idx = NodeFactoryExtra.intToNode(i);
            Node member = members.get(i);
            BindingMap b = BindingFactory.create(binding);
            b.add(varIndex, idx);
            b.add(varMember, member);
            bindings2.add(b);
        }
        return new QueryIterPlainWrapper(bindings2.iterator(), execCxt);
    }
}

