/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.core;

import java.util.Set;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.sdb.core.Scope;
import org.apache.jena.sdb.core.ScopeEntry;
import org.apache.jena.sdb.core.ScopeStatus;
import org.apache.jena.sparql.core.Var;

public class ScopeOptional
implements Scope {
    private Scope scope;
    private ScopeStatus scopeStatus = ScopeStatus.OPTIONAL;

    public ScopeOptional(Scope subScope) {
        this.scope = subScope;
    }

    @Override
    public ScopeEntry findScopeForVar(Var var) {
        ScopeEntry e2 = this.scope.findScopeForVar(var);
        if (e2 == null) {
            return null;
        }
        e2 = e2.duplicate();
        e2.setStatus(this.scopeStatus);
        return e2;
    }

    @Override
    public Set<Var> getVars() {
        return this.scope.getVars();
    }

    @Override
    public boolean isEmpty() {
        return this.scope.isEmpty();
    }

    @Override
    public Set<ScopeEntry> findScopes() {
        Set<ScopeEntry> x = this.scope.findScopes();
        Iter.apply(x.iterator(), ScopeEntry.SetOpt);
        return x;
    }

    @Override
    public boolean hasColumnForVar(Var var) {
        return this.scope.hasColumnForVar(var);
    }

    public String toString() {
        return "Opt(" + this.scope.toString() + ")";
    }
}

