/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.engine;

import org.apache.jena.query.ARQ;
import org.apache.jena.query.Query;
import org.apache.jena.sdb.SDB;
import org.apache.jena.sdb.SDBException;
import org.apache.jena.sdb.Store;
import org.apache.jena.sdb.compiler.OpSQL;
import org.apache.jena.sdb.compiler.SDBCompile;
import org.apache.jena.sdb.core.SDBRequest;
import org.apache.jena.sdb.store.DatasetGraphSDB;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.optimize.TransformFilterEquality;
import org.apache.jena.sparql.algebra.optimize.TransformPropertyFunction;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.Plan;
import org.apache.jena.sparql.engine.QueryEngineBase;
import org.apache.jena.sparql.engine.QueryEngineFactory;
import org.apache.jena.sparql.engine.QueryEngineRegistry;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingRoot;
import org.apache.jena.sparql.engine.iterator.QueryIterRoot;
import org.apache.jena.sparql.engine.iterator.QueryIterSingleton;
import org.apache.jena.sparql.engine.iterator.QueryIteratorCheck;
import org.apache.jena.sparql.engine.main.QC;
import org.apache.jena.sparql.util.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryEngineSDB
extends QueryEngineBase {
    private static Logger log = LoggerFactory.getLogger(QueryEngineSDB.class);
    private Store store;
    private SDBRequest request = null;
    private Op originalOp = null;
    private static QueryEngineFactory factory = new QueryEngineFactorySDB();

    public QueryEngineSDB(Store store, Query q) {
        this(new DatasetGraphSDB(store, SDB.getContext().copy()), q, BindingRoot.create(), SDB.getContext().copy());
    }

    public QueryEngineSDB(DatasetGraphSDB dsg, Query query2, Binding initialBinding, Context context) {
        super(query2, (DatasetGraph)dsg, initialBinding, context);
        this.init(dsg, query2, initialBinding, context);
    }

    public QueryEngineSDB(DatasetGraphSDB dsg, Op op, Binding initialBinding, Context context) {
        super(op, (DatasetGraph)dsg, initialBinding, context);
        this.init(dsg, null, initialBinding, context);
    }

    private void init(DatasetGraphSDB dsg, Query query2, Binding initialBinding, Context context) {
        if (context == null) {
            context = ARQ.getContext().copy();
        }
        if (query2 != null && query2.hasDatasetDescription()) {
            throw new SDBException("Queries with dataset descriptions (FROM/FROM NAMED) not supported");
        }
        if (context.isDefined(ARQConstants.sysDatasetDescription)) {
            throw new SDBException("Queries with dataset descriptions set in the context not supported");
        }
        this.store = dsg.getStore();
        this.request = new SDBRequest(this.store, query2, context);
        Op op = this.originalOp = this.getOp();
        op = Transformer.transform(new TransformPropertyFunction(context), op);
        op = Transformer.transform(new TransformFilterEquality(), op);
        op = Algebra.toQuadForm(op);
        op = SDBCompile.compile(this.store, op, initialBinding, context, this.request);
        this.setOp(op);
    }

    public SDBRequest getRequest() {
        return this.request;
    }

    @Override
    public void close() {
        super.close();
    }

    @Override
    public QueryIterator eval(Op op, DatasetGraph dsg, Binding binding, Context context) {
        ExecutionContext execCxt = new ExecutionContext(context, dsg.getDefaultGraph(), dsg, QC.getFactory(context));
        if (!(op instanceof OpSQL)) {
            QueryIterSingleton input = QueryIterSingleton.create(binding, execCxt);
            QueryIterator qIter = QC.execute(op, input, execCxt);
            qIter = QueryIteratorCheck.check(qIter, execCxt);
            return qIter;
        }
        OpSQL opSQL = (OpSQL)op;
        QueryIterator qIter = opSQL.getSqlNode() == null ? (binding != null && binding.size() != 0 ? QueryIterSingleton.create(binding, execCxt) : QueryIterRoot.create(execCxt)) : opSQL.exec(binding, execCxt);
        qIter = QueryIteratorCheck.check(qIter, execCxt);
        return qIter;
    }

    public static QueryEngineFactory getFactory() {
        return factory;
    }

    public static void register() {
        QueryEngineRegistry.addFactory(factory);
    }

    public static void unregister() {
        QueryEngineRegistry.removeFactory(factory);
    }

    private static class QueryEngineFactorySDB
    implements QueryEngineFactory {
        private QueryEngineFactorySDB() {
        }

        @Override
        public boolean accept(Query query2, DatasetGraph dataset, Context context) {
            return dataset instanceof DatasetGraphSDB;
        }

        @Override
        public Plan create(Query query2, DatasetGraph dataset, Binding inputBinding, Context context) {
            QueryEngineSDB qe = new QueryEngineSDB((DatasetGraphSDB)dataset, query2, inputBinding, context);
            return qe.getPlan();
        }

        @Override
        public boolean accept(Op op, DatasetGraph dataset, Context context) {
            return dataset instanceof DatasetGraphSDB;
        }

        @Override
        public Plan create(Op op, DatasetGraph dataset, Binding inputBinding, Context context) {
            if (inputBinding == null) {
                inputBinding = BindingRoot.create();
            }
            QueryEngineSDB qe = new QueryEngineSDB((DatasetGraphSDB)dataset, op, inputBinding, context);
            return qe.getPlan();
        }
    }
}

