/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.layout1;

import java.sql.SQLException;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.sdb.core.SDBRequest;
import org.apache.jena.sdb.core.ScopeEntry;
import org.apache.jena.sdb.core.sqlexpr.SqlColumn;
import org.apache.jena.sdb.core.sqlnode.SqlNode;
import org.apache.jena.sdb.layout1.EncoderDecoder;
import org.apache.jena.sdb.sql.ResultSetJDBC;
import org.apache.jena.sdb.sql.SQLUtils;
import org.apache.jena.sdb.store.SQLBridgeBase;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.binding.BindingMap;

public class SQLBridge1
extends SQLBridgeBase {
    private EncoderDecoder codec;

    public SQLBridge1(SDBRequest request, SqlNode sqlNode, List<Var> projectVars, EncoderDecoder codec) {
        super(request, sqlNode, projectVars);
        this.codec = codec;
    }

    @Override
    protected void buildValues() {
        if (this.getSqlNode().isSelectBlock()) {
            this.setSqlNode(this.getSqlNode().asSelectBlock().clearView());
        }
    }

    @Override
    protected void buildProject() {
        for (Var v : this.getProject()) {
            ScopeEntry e2;
            if (!v.isNamedVar() || (e2 = this.getSqlExprNode().getIdScope().findScopeForVar(v)) == null) continue;
            SqlColumn c = e2.getColumn();
            String sqlVarName = this.allocSqlName(v);
            this.addProject(c, sqlVarName);
            this.addAnnotation(sqlVarName + "=" + v.toString());
        }
        this.setAnnotation();
    }

    @Override
    protected Binding assembleBinding(ResultSetJDBC rs, Binding parent) {
        BindingMap b = BindingFactory.create(parent);
        for (Var v : this.getProject()) {
            String sqlVarName = this.getSqlName(v);
            if (sqlVarName == null) continue;
            try {
                String s = rs.get().getString(sqlVarName);
                if (s == null) continue;
                s = SQLUtils.unescapeStr(s);
                Node n = this.codec.decode(s);
                b.add(v, n);
            }
            catch (SQLException sQLException) {}
        }
        return b;
    }
}

