/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.print;

import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.io.Printable;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.sdb.print.ActionPrint;

public class StreamsPrint {
    public static <T extends Printable> String printString(Iterable<? extends T> struct) {
        return StreamsPrint.printString(struct, " ");
    }

    public static <T extends Printable> String printString(Iterable<? extends T> struct, String sep) {
        IndentedLineBuffer b = new IndentedLineBuffer();
        Iter.apply(struct.iterator(), new ActionPrint(b, sep));
        return b.asString();
    }

    public static <T extends Printable> void print(IndentedWriter out, Iterable<? extends T> struct) {
        Iter.apply(struct.iterator(), new ActionPrint(out));
    }

    public static <T extends Printable> void print(IndentedWriter out, Iterable<? extends T> struct, String sep) {
        Iter.apply(struct.iterator(), new ActionPrint(out, sep));
    }
}

