/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.script;

import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sdb.assembler.AssemblerVocab;
import org.apache.jena.sdb.assembler.CommandAssemblerException;
import org.apache.jena.sdb.script.CmdDesc;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.apache.jena.vocabulary.RDF;

public class CmdDescAssembler
extends AssemblerBase
implements Assembler {
    @Override
    public Object open(Assembler a, Resource root2, Mode mode) {
        CmdDesc cd = new CmdDesc();
        String main = GraphUtils.getStringValue(root2, AssemblerVocab.pMain);
        if (main == null) {
            main = GraphUtils.getStringValue(root2, AssemblerVocab.pClassname);
        }
        cd.setCmd(main);
        Resource x = GraphUtils.getResourceValue(root2, AssemblerVocab.pArgs);
        if (x != null) {
            while (!x.equals(RDF.nil)) {
                RDFNode e2 = x.getRequiredProperty(RDF.first).getObject();
                x = x.getRequiredProperty(RDF.rest).getResource();
                if (e2.isLiteral()) {
                    cd.addPosn(((Literal)e2).getString());
                    continue;
                }
                Resource entry = (Resource)e2;
                String name = GraphUtils.getStringValue(entry, AssemblerVocab.pArgName);
                String value = GraphUtils.getStringValue(entry, AssemblerVocab.pArgValue);
                if (value == null) {
                    throw new CommandAssemblerException(entry, "Strange entry: " + entry);
                }
                if (name != null) {
                    cd.addNamedArg(name, value);
                    continue;
                }
                cd.addPosn(value);
            }
        }
        return cd;
    }
}

