/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.shared;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jena.sparql.util.Symbol;

public class SymbolRegistry<T extends Symbol> {
    protected Set<T> registeredSymbols = new HashSet<T>();
    protected Map<String, T> registeredNames = new HashMap<String, T>();

    public void register(T symbol) {
        this.register(null, symbol);
    }

    public void register(String name, T symbol) {
        if (name == null) {
            name = ((Symbol)symbol).getSymbol();
        }
        this.registeredSymbols.add(symbol);
        this.registeredNames.put(name, symbol);
    }

    public T lookup(String symName) {
        for (String name : this.registeredNames.keySet()) {
            if (!symName.equalsIgnoreCase(name)) continue;
            return (T)((Symbol)this.registeredNames.get(name));
        }
        return null;
    }

    public List<String> allNames() {
        return new ArrayList<String>(this.registeredNames.keySet());
    }

    public List<T> allSymbols() {
        return new ArrayList<T>(this.registeredSymbols);
    }
}

