/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.store;

import java.util.Iterator;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.sdb.Store;
import org.apache.jena.sdb.graph.GraphSDB;
import org.apache.jena.sdb.store.LibSDB;
import org.apache.jena.sdb.util.StoreUtils;
import org.apache.jena.shared.Lock;
import org.apache.jena.shared.LockMRSW;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphTriplesQuads;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.core.TransactionalNotSupported;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.graph.GraphUtils;

public class DatasetGraphSDB
extends DatasetGraphTriplesQuads
implements DatasetGraph,
Closeable {
    private final Store store;
    private Lock lock = new LockMRSW();
    private final Context context;
    private GraphSDB defaultGraph;
    private final Transactional txn = new TransactionalNotSupported();

    public DatasetGraphSDB(Store store, Context context) {
        this(store, new GraphSDB(store), context);
    }

    public DatasetGraphSDB(Store store, GraphSDB graph, Context context) {
        this.store = store;
        this.defaultGraph = graph;
        this.context = context;
    }

    public Store getStore() {
        return this.store;
    }

    @Override
    public Iterator<Node> listGraphNodes() {
        return StoreUtils.storeGraphNames(this.store);
    }

    @Override
    public boolean containsGraph(Node graphNode) {
        return StoreUtils.containsGraph(this.store, graphNode);
    }

    @Override
    public Graph getDefaultGraph() {
        return this.defaultGraph;
    }

    @Override
    public Graph getGraph(Node graphNode) {
        return new GraphSDB(this.store, graphNode);
    }

    @Override
    protected void addToDftGraph(Node s, Node p, Node o) {
        this.getDefaultGraph().add(new Triple(s, p, o));
    }

    @Override
    protected void addToNamedGraph(Node g, Node s, Node p, Node o) {
        this.getGraph(g).add(new Triple(s, p, o));
    }

    @Override
    protected void deleteFromDftGraph(Node s, Node p, Node o) {
        this.getDefaultGraph().delete(new Triple(s, p, o));
    }

    @Override
    protected void deleteFromNamedGraph(Node g, Node s, Node p, Node o) {
        this.getGraph(g).delete(new Triple(s, p, o));
    }

    @Override
    protected Iterator<Quad> findInDftGraph(Node s, Node p, Node o) {
        return GraphUtils.triples2quadsDftGraph(LibSDB.findTriplesInDftGraph(this, s, p, o));
    }

    @Override
    protected Iterator<Quad> findInAnyNamedGraphs(Node s, Node p, Node o) {
        return LibSDB.findInQuads(this, Node.ANY, s, p, o);
    }

    @Override
    protected Iterator<Quad> findInSpecificNamedGraph(Node g, Node s, Node p, Node o) {
        return LibSDB.findInQuads(this, g, s, p, o);
    }

    @Override
    public void close() {
        this.store.close();
    }

    @Override
    public void begin(ReadWrite mode) {
        this.txn.begin(mode);
    }

    @Override
    public void commit() {
        this.txn.commit();
    }

    @Override
    public void abort() {
        this.txn.abort();
    }

    @Override
    public boolean isInTransaction() {
        return this.txn.isInTransaction();
    }

    @Override
    public void end() {
        this.txn.end();
    }

    @Override
    public boolean supportsTransactions() {
        return false;
    }

    @Override
    public boolean supportsTransactionAbort() {
        return false;
    }
}

