/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.store;

import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sdb.SDB;
import org.apache.jena.sdb.engine.QueryEngineSDB;
import org.apache.jena.sparql.algebra.op.Op0;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.Plan;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingRoot;

public class LibSDB {
    public static Iterator<Quad> findInQuads(DatasetGraph dsg, Node g, Node s, Node p, Node o) {
        Iterator<Binding> iter;
        Node vg = LibSDB.varOrConst(g, "g");
        Node vs = LibSDB.varOrConst(s, "s");
        Node vp = LibSDB.varOrConst(p, "p");
        Node vo = LibSDB.varOrConst(o, "o");
        Triple triple = new Triple(vs, vp, vo);
        BasicPattern pattern = new BasicPattern();
        pattern.add(triple);
        OpQuadPattern op = new OpQuadPattern(vg, pattern);
        Plan plan = QueryEngineSDB.getFactory().create(op, dsg, BindingRoot.create(), null);
        QueryIterator qIter = plan.iterator();
        if (SDB.getContext().isTrue(SDB.streamGraphAPI)) {
            iter = qIter;
        } else {
            List<Binding> x = Iter.toList(qIter);
            Iterator<Binding> qIter2 = x.iterator();
            qIter.close();
            iter = qIter2;
        }
        return Iter.map(iter, b -> LibSDB.bindingToQuad(vg, vs, vp, vo, b));
    }

    public static Iterator<Triple> findTriplesInDftGraph(DatasetGraph dsg, Node s, Node p, Node o) {
        return LibSDB.findTriples(dsg, null, s, p, o);
    }

    public static Iterator<Triple> findTriples(DatasetGraph dsg, Node g, Node s, Node p, Node o) {
        Iterator<Binding> iter;
        if (Var.isVar(g)) {
            throw new InternalErrorException("Graph node is a variable : " + g);
        }
        Node vs = LibSDB.varOrConst(s, "s");
        Node vp = LibSDB.varOrConst(p, "p");
        Node vo = LibSDB.varOrConst(o, "o");
        Triple triple = new Triple(vs, vp, vo);
        BasicPattern pattern = new BasicPattern();
        pattern.add(triple);
        Op0 op = g != null ? new OpQuadPattern(g, pattern) : new OpBGP(pattern);
        Plan plan = QueryEngineSDB.getFactory().create(op, dsg, BindingRoot.create(), null);
        QueryIterator qIter = plan.iterator();
        if (SDB.getContext().isTrue(SDB.streamGraphAPI)) {
            iter = qIter;
        } else {
            List<Binding> x = Iter.toList(qIter);
            Iterator<Binding> qIter2 = x.iterator();
            qIter.close();
            iter = qIter2;
        }
        return Iter.map(iter, b -> LibSDB.bindingToTriple(vs, vp, vo, b));
    }

    private static Node varOrConst(Node n, String varName) {
        if (n != null && n != Node.ANY) {
            return n;
        }
        return Var.alloc(varName);
    }

    private static Quad bindingToQuad(Node vg, Node vs, Node vp, Node vo, Binding binding) {
        Node gResult = vg;
        Node sResult = vs;
        Node pResult = vp;
        Node oResult = vo;
        if (Var.isVar(vg)) {
            gResult = binding.get(Var.alloc(vg));
        }
        if (Var.isVar(vs)) {
            sResult = binding.get(Var.alloc(vs));
        }
        if (Var.isVar(vp)) {
            pResult = binding.get(Var.alloc(vp));
        }
        if (Var.isVar(vo)) {
            oResult = binding.get(Var.alloc(vo));
        }
        return Quad.create(gResult, sResult, pResult, oResult);
    }

    private static Triple bindingToTriple(Node vs, Node vp, Node vo, Binding binding) {
        Node sResult = vs;
        Node pResult = vp;
        Node oResult = vo;
        if (Var.isVar(vs)) {
            sResult = binding.get(Var.alloc(vs));
        }
        if (Var.isVar(vp)) {
            pResult = binding.get(Var.alloc(vp));
        }
        if (Var.isVar(vo)) {
            oResult = binding.get(Var.alloc(vo));
        }
        return Triple.create(sResult, pResult, oResult);
    }
}

