/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.util;

import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.query.Query;
import org.apache.jena.sdb.Store;
import org.apache.jena.sdb.compiler.OpSQL;
import org.apache.jena.sdb.engine.QueryEngineSDB;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpPrefixesUsed;
import org.apache.jena.sparql.algebra.OpVisitorBase;
import org.apache.jena.sparql.algebra.OpWalker;
import org.apache.jena.sparql.algebra.op.OpExt;

public class PrintSDB {
    public static String divider = "----------------";

    public static void print(Store store, Query query2, QueryEngineSDB queryEngine) {
        if (queryEngine == null) {
            queryEngine = new QueryEngineSDB(store, query2);
        }
        Op op = queryEngine.getPlan().getOp();
        System.out.println(op.toString(query2.getPrefixMapping()));
    }

    public static void print(Op op) {
        PrintSDB.print(op, null);
    }

    public static void print(Op op, PrefixMapping pmap) {
        if (pmap == null) {
            pmap = OpPrefixesUsed.used(op, ARQConstants.getGlobalPrefixMap());
        }
        System.out.print(op.toString(pmap));
    }

    public static void printSQL(Op op) {
        OpWalker.walk(op, new PrintSQL());
    }

    public static void printSqlNodes(Op op) {
        OpWalker.walk(op, new PrintSqlNodes());
    }

    static class PrintSQL
    extends OpVisitorBase {
        boolean first = true;
        private IndentedWriter out;

        PrintSQL(IndentedWriter out) {
            this.out = out;
        }

        PrintSQL() {
            this.out = new IndentedWriter(System.out);
        }

        @Override
        public void visit(OpExt op) {
            if (!(op instanceof OpSQL)) {
                super.visit(op);
                return;
            }
            OpSQL opSQL = (OpSQL)op;
            if (!this.first) {
                this.out.println(divider);
            }
            this.out.print(opSQL.toSQL());
            this.out.ensureStartOfLine();
            this.out.flush();
            this.first = false;
        }
    }

    static class PrintSqlNodes
    extends OpVisitorBase {
        boolean first = true;
        private IndentedWriter out;

        PrintSqlNodes(IndentedWriter out) {
            this.out = out;
        }

        PrintSqlNodes() {
            this.out = new IndentedWriter(System.out);
        }

        @Override
        public void visit(OpExt op) {
            if (!(op instanceof OpSQL)) {
                super.visit(op);
                return;
            }
            OpSQL opSQL = (OpSQL)op;
            if (!this.first) {
                this.out.println(divider);
            }
            opSQL.output(this.out);
            this.out.ensureStartOfLine();
            this.out.flush();
            this.first = false;
        }
    }
}

