/*
 * Decompiled with CFR 0.152.
 */
package sdb.cmd;

import java.sql.SQLException;
import java.util.List;
import jena.cmd.ArgDecl;
import jena.cmd.CmdArgModule;
import jena.cmd.CmdGeneral;
import jena.cmd.ModBase;
import jena.cmd.TerminationException;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sdb.SDBException;
import org.apache.jena.sdb.SDBFactory;
import org.apache.jena.sdb.Store;
import org.apache.jena.sdb.StoreDesc;
import org.apache.jena.sdb.sql.MySQLEngineType;
import org.apache.jena.sdb.sql.SAPStorageType;
import org.apache.jena.sdb.sql.SDBConnection;
import org.apache.jena.sdb.sql.SDBExceptionSQL;
import org.apache.jena.sdb.store.DatasetStore;
import org.apache.jena.sdb.store.LayoutType;
import org.apache.jena.sdb.store.StoreFactory;
import org.apache.jena.shared.NotFoundException;
import org.apache.jena.util.FileManager;

public class ModStore
extends ModBase {
    protected final ArgDecl argDeclSDBdesc = new ArgDecl(true, "sdb", "store");
    protected final ArgDecl argDeclJdbcURL = new ArgDecl(true, "jdbc");
    protected final ArgDecl argDeclJdbcDriver = new ArgDecl(true, "jdbcDriver", "jdbcdriver");
    protected final ArgDecl argDeclDbHost = new ArgDecl(true, "dbHost", "dbhost");
    protected final ArgDecl argDeclDbName = new ArgDecl(true, "dbName", "db");
    protected final ArgDecl argDeclDbType = new ArgDecl(true, "dbType", "dbtype");
    protected final ArgDecl argDeclDbUser = new ArgDecl(true, "dbUser", "user");
    protected final ArgDecl argDeclDbPassword = new ArgDecl(true, "dbPassword", "password", "pw");
    protected final ArgDecl argDeclLayout = new ArgDecl(true, "layout");
    protected final ArgDecl argDeclMySQLEngine = new ArgDecl(true, "engine");
    protected final ArgDecl argDeclSAPStorage = new ArgDecl(true, "storage");
    StoreDesc storeDesc = null;
    SDBConnection connection = null;
    boolean connectionAttempted = false;
    Store store = null;
    Dataset dataset = null;
    Model model = null;
    List<String> loadFiles = null;
    boolean formatFirst = false;
    boolean hsqlDetech = false;
    boolean isHSQL = false;

    public ModStore() {
        SDBConnection.logSQLExceptions = true;
    }

    @Override
    public void registerWith(CmdGeneral cmdLine) {
        boolean AddUsage = false;
        cmdLine.getUsage().startCategory("Store and connection");
        cmdLine.add(this.argDeclSDBdesc, "--sdb=<file>", "Store and connection description");
        cmdLine.add(this.argDeclLayout, "--layout=NAME", "Database schema");
        cmdLine.add(this.argDeclJdbcURL);
        cmdLine.add(this.argDeclJdbcDriver);
        cmdLine.add(this.argDeclDbHost);
        cmdLine.add(this.argDeclDbName);
        cmdLine.add(this.argDeclDbType);
        cmdLine.add(this.argDeclDbUser);
        cmdLine.add(this.argDeclDbPassword);
        cmdLine.add(this.argDeclMySQLEngine);
    }

    @Override
    public void processArgs(CmdArgModule cmdLine) {
        if (!cmdLine.contains(this.argDeclSDBdesc)) {
            System.err.println("No store description");
            throw new TerminationException(1);
        }
        String f = cmdLine.getArg(this.argDeclSDBdesc).getValue();
        try {
            this.storeDesc = StoreDesc.read(f);
            if (this.storeDesc.getLayout() == null) {
                System.err.println("No layout or unrecognized layout");
                throw new TerminationException(1);
            }
        }
        catch (SDBException ex) {
            System.err.println("Failed to read the store description");
            System.err.println(ex.getMessage());
            throw new TerminationException(1);
        }
        catch (NotFoundException ex) {
            System.err.println(f + " : Store description not found");
            throw new TerminationException(1);
        }
        if (cmdLine.contains(this.argDeclDbHost)) {
            this.storeDesc.connDesc.setHost(cmdLine.getArg(this.argDeclDbHost).getValue());
        }
        if (cmdLine.contains(this.argDeclDbName)) {
            this.storeDesc.connDesc.setName(cmdLine.getArg(this.argDeclDbName).getValue());
        }
        if (cmdLine.contains(this.argDeclDbType)) {
            this.storeDesc.connDesc.setType(cmdLine.getArg(this.argDeclDbType).getValue());
        }
        if (cmdLine.contains(this.argDeclDbUser)) {
            this.storeDesc.connDesc.setUser(cmdLine.getArg(this.argDeclDbUser).getValue());
        }
        if (cmdLine.contains(this.argDeclDbPassword)) {
            this.storeDesc.connDesc.setPassword(cmdLine.getArg(this.argDeclDbPassword).getValue());
        }
        if (cmdLine.contains(this.argDeclMySQLEngine)) {
            this.storeDesc.engineType = MySQLEngineType.convert(cmdLine.getArg(this.argDeclMySQLEngine).getValue());
        }
        if (cmdLine.contains(this.argDeclSAPStorage)) {
            this.storeDesc.storageType = SAPStorageType.convert(cmdLine.getArg(this.argDeclSAPStorage).getValue());
        }
        if (cmdLine.contains(this.argDeclLayout)) {
            String layoutName = cmdLine.getArg(this.argDeclLayout).getValue();
            this.storeDesc.setLayout(LayoutType.fetch(layoutName));
            if (this.storeDesc.getLayout() == null) {
                System.err.println("Don't recognize layout name '" + layoutName + "'");
                throw new TerminationException(2);
            }
        }
        if (cmdLine.contains(this.argDeclJdbcDriver)) {
            String driverName = cmdLine.getArg(this.argDeclJdbcDriver).getValue();
            this.storeDesc.connDesc.setDriver(driverName);
        }
    }

    public Store getStore() {
        if (this.store == null) {
            this.store = StoreFactory.create(this.storeDesc, this.getConnection());
            if (this.formatFirst) {
                this.getStore().getTableFormatter().format();
            }
        }
        return this.store;
    }

    public boolean hasStore() {
        return this.store != null;
    }

    public StoreDesc getStoreDesc() {
        return this.storeDesc;
    }

    public void setDbName(String dbName) {
        this.storeDesc.connDesc.setName(dbName);
    }

    public Dataset getDataset() {
        if (this.dataset == null) {
            this.dataset = DatasetStore.create(this.getStore());
            this.initData(this.dataset.getDefaultModel());
        }
        return this.dataset;
    }

    private void initData(Model model) {
        if (this.loadFiles != null) {
            for (String s : this.loadFiles) {
                FileManager.get().readModel(model, s);
            }
        }
        this.loadFiles = null;
    }

    public boolean isConnected() {
        return this.connection != null;
    }

    public SDBConnection getConnection() {
        if (!this.isConnected() && !this.connectionAttempted) {
            try {
                this.connection = SDBFactory.createConnection(this.storeDesc.connDesc);
            }
            finally {
                this.connectionAttempted = true;
            }
        }
        return this.connection;
    }

    public boolean isHSQL() {
        if (!this.hsqlDetech) {
            try {
                this.isHSQL = this.getConnection().getSqlConnection().getMetaData().getDatabaseProductName().contains("HSQL");
            }
            catch (SQLException ex) {
                throw new SDBExceptionSQL(ex);
            }
        }
        return this.isHSQL;
    }

    public void closedown() {
        if (this.store != null) {
            this.store.close();
        }
    }
}

