/*
 * Decompiled with CFR 0.152.
 */
package sdb;

import java.io.OutputStream;
import java.util.List;
import jena.cmd.ArgDecl;
import jena.cmd.CmdException;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.sdb.SDB;
import sdb.cmd.CmdArgsDB;
import sdb.cmd.ModGraph;

public class sdbdump
extends CmdArgsDB {
    public static final String usage = "sdbdump --sdb <SPEC> [--out syntax]";
    private static ModGraph modGraph = new ModGraph();
    static ArgDecl argDeclSyntax = new ArgDecl(true, "output", "out");

    public static void main(String ... argv) {
        SDB.init();
        new sdbdump(argv).mainRun();
    }

    protected sdbdump(String ... args) {
        super(args);
        this.addModule(modGraph);
        this.add(argDeclSyntax, "--output=", "RDF Syntax for output (For datasets, TriG, N-Quads; for graphs, any RDF syntax)");
    }

    @Override
    protected String getCommandName() {
        return Lib.className(this);
    }

    @Override
    protected String getSummary() {
        return Lib.className(this) + " --sdb <SPEC> [--out syntax]";
    }

    @Override
    protected void processModulesAndArgs() {
        if (this.getNumPositional() > 0) {
            this.cmdError("No positional arguments allowed", true);
        }
    }

    @Override
    protected void execCmd(List<String> args) {
        String syntax = "N-QUADS";
        if (this.contains(argDeclSyntax)) {
            syntax = this.getArg(argDeclSyntax).getValue();
        }
        Lang lang = RDFLanguages.nameToLang(syntax);
        try {
            if (modGraph.getGraphName() == null) {
                if (!RDFLanguages.isQuads(lang)) {
                    this.cmdError("Not a 'quads' language (try 'N-Quads' or 'TriG')", true);
                }
                Dataset dataset = this.getModStore().getDataset();
                RDFDataMgr.write((OutputStream)System.out, dataset, lang);
            } else {
                Model model = modGraph.getModel(this.getStore());
                RDFDataMgr.write((OutputStream)System.out, model, lang);
            }
        }
        catch (CmdException ex) {
            throw ex;
        }
        catch (Exception ex) {
            System.err.println("Exception: " + ex + " :: " + ex.getMessage());
            ex.printStackTrace(System.err);
        }
    }
}

