/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;

public class WebContent {
    public static final String contentTypeTurtle = "text/turtle";
    public static final ContentType ctTurtle = ContentType.create("text/turtle");
    public static final String contentTypeTurtleAlt1 = "application/turtle";
    public static final ContentType ctTurtleAlt1 = ContentType.create("application/turtle");
    public static final String contentTypeTurtleAlt2 = "application/x-turtle";
    public static final ContentType ctTurtleAlt2 = ContentType.create("application/x-turtle");
    public static final String contentTypeRDFXML = "application/rdf+xml";
    public static final ContentType ctRDFXML = ContentType.create("application/rdf+xml");
    public static final String contentTypeRDFJSON = "application/rdf+json";
    public static final ContentType ctRDFJSON = ContentType.create("application/rdf+json");
    public static final String contentTypeJSONLD = "application/ld+json";
    public static final ContentType ctJSONLD = ContentType.create("application/ld+json");
    public static final String contentTypeTextPlain = "text/plain";
    public static final ContentType ctTextPlain = ContentType.create("text/plain");
    public static final String contentTypeNTriples = "application/n-triples";
    public static final ContentType ctNTriples = ContentType.create("application/n-triples");
    public static final String contentTypeNTriplesAlt = "text/plain";
    public static final ContentType ctNTriplesAlt = ContentType.create("text/plain");
    public static final String contentTypeXML = "application/xml";
    public static final ContentType ctXML = ContentType.create("application/xml");
    public static final String contentTypeXMLAlt = "text/xml";
    public static final ContentType ctXMLAlt = ContentType.create("text/xml");
    public static final String contentTypeTriG = "text/trig";
    public static final ContentType ctTriG = ContentType.create("text/trig");
    public static final String contentTypeNQuads = "application/n-quads";
    public static final ContentType ctNQuads = ContentType.create("application/n-quads");
    public static final String contentTypeTriGAlt1 = "application/x-trig";
    public static final ContentType ctTriGAlt1 = ContentType.create("application/x-trig");
    public static final String contentTypeTriGAlt2 = "application/trig";
    public static final ContentType ctTriGAlt2 = ContentType.create("application/trig");
    public static final String contentTypeRDFThrift = "application/rdf+thrift";
    public static final ContentType ctRDFTHRIFT = ContentType.create("application/rdf+thrift");
    public static final String contentTypeNQuadsAlt1 = "text/n-quads";
    public static final ContentType ctNQuadsAlt1 = ContentType.create("text/n-quads");
    public static final String contentTypeNQuadsAlt2 = "text/nquads";
    public static final ContentType ctNQuadsAlt2 = ContentType.create("text/nquads");
    public static final String contentTypeTriX = "application/trix";
    public static final ContentType ctTriX = ContentType.create("application/trix");
    public static final String contentTypeTriXxml = "application/trix+xml";
    public static final ContentType ctTriXxml = ContentType.create("application/trix+xml");
    public static final String contentTypeOctets = "application/octet-stream";
    public static final ContentType ctOctets = ContentType.create("application/octet-stream");
    public static final String contentTypeMultipartMixed = "multipart/mixed";
    public static final ContentType ctMultipartMixed = ContentType.create("multipart/mixed");
    public static final String contentTypeMultipartFormData = "multipart/form-data";
    public static final ContentType ctMultipartFormData = ContentType.create("multipart/form-data");
    public static final String contentTypeMultiAlt = "multipart/alternative";
    public static final ContentType ctMultiAlt = ContentType.create("multipart/alternative");
    public static final String contentTypeRdfJson = "application/rdf+json";
    public static final ContentType ctRdfJson = ContentType.create("application/rdf+json");
    public static final String contentTypeN3 = "text/rdf+n3";
    public static final ContentType ctTypeN3 = ContentType.create("text/rdf+n3");
    public static final String contentTypeN3Alt1 = "application/n3";
    public static final ContentType ctN3Alt1 = ContentType.create("application/n3");
    public static final String contentTypeN3Alt2 = "text/n3";
    public static final ContentType ctN3Alt2 = ContentType.create("text/n3");
    public static final String contentTypeResultsXML = "application/sparql-results+xml";
    public static final ContentType ctResultsXML = ContentType.create("application/sparql-results+xml");
    public static final String contentTypeResultsJSON = "application/sparql-results+json";
    public static final ContentType ctResultsJSON = ContentType.create("application/sparql-results+json");
    public static final String contentTypeJSON = "application/json";
    public static final ContentType ctJSON = ContentType.create("application/json");
    public static final String contentTypeResultsThrift = "application/sparql-results+thrift";
    public static final ContentType ctResultsThrift = ContentType.create("application/sparql-results+thrift");
    public static final String contentTypeResultsBIO = "application/sparql-results+bio";
    public static final ContentType ctResultsBIO = ContentType.create("application/sparql-results+bio");
    public static final String contentTypeSPARQLQuery = "application/sparql-query";
    public static final ContentType ctSPARQLQuery = ContentType.create("application/sparql-query");
    public static final String contentTypeSPARQLUpdate = "application/sparql-update";
    public static final ContentType ctSPARQLUpdate = ContentType.create("application/sparql-update");
    public static final String contentTypeHTMLForm = "application/x-www-form-urlencoded";
    public static final ContentType ctHTMLForm = ContentType.create("application/x-www-form-urlencoded");
    public static final String contentTypeTextCSV = "text/csv";
    public static final ContentType ctTextCSV = ContentType.create("text/csv");
    public static final String contentTypeTextTSV = "text/tab-separated-values";
    public static final ContentType ctTextTSV = ContentType.create("text/tab-separated-values");
    public static final String contentTypeSSE = "text/sse";
    public static final ContentType ctSSE = ContentType.create("text/sse");
    public static final String charsetUTF8 = "utf-8";
    public static final String charsetASCII = "ascii";
    public static final String langRDFXML = "RDF/XML";
    public static final String langRDFXMLAbbrev = "RDF/XML-ABBREV";
    public static final String langNTriple = "N-TRIPLE";
    public static final String langNTriples = "N-TRIPLES";
    public static final String langN3 = "N3";
    public static final String langTurtle = "TURTLE";
    public static final String langTTL = "TTL";
    public static final String langRdfJson = "RDF/JSON";
    public static final String langNQuads = "NQUADS";
    public static final String langTriG = "TRIG";
    public static final String encodingUTF8 = "utf-8";
    private static final String defaultGraphAccept = "text/turtle,application/n-triples;q=0.9,application/ld+json;q=0.8,application/rdf+xml;q=0.7";
    public static final String defaultGraphAcceptHeader = "text/turtle,application/n-triples;q=0.9,application/ld+json;q=0.8,application/rdf+xml;q=0.7,*/*;q=0.5";
    private static final String defaultDatasetAccept = "application/trig,application/n-quads;q=0.9,text/x-nquads;q=0.8,application/x-trig;q=0.7,application/ld+json;q=0.5";
    public static final String defaultDatasetAcceptHeader = "application/trig,application/n-quads;q=0.9,text/x-nquads;q=0.8,application/x-trig;q=0.7,application/ld+json;q=0.5,*/*;q=0.5";
    public static final String defaultRDFAcceptHeader = "text/turtle,application/n-triples;q=0.9,application/rdf+xml;q=0.7,application/trig,application/n-quads;q=0.9,text/x-nquads;q=0.8,application/x-trig;q=0.7,application/ld+json;q=0.6,*/*;q=0.5";

    public static String contentTypeCanonical(String contentType) {
        Lang lang = RDFLanguages.contentTypeToLang(contentType);
        if (lang == null) {
            return null;
        }
        return lang.getHeaderString();
    }

    public static boolean matchContentType(ContentType ct1, ContentType ct2) {
        if (ct1 == null || ct2 == null) {
            return false;
        }
        return WebContent.matchContentType(ct1.getContentType(), ct2.getContentType());
    }

    public static boolean matchContentType(String ct1, String ct2) {
        return Lib.equalsIgnoreCase(ct1, ct2);
    }

    public static boolean isHtmlForm(ContentType ct) {
        if (ct == null) {
            return false;
        }
        return contentTypeHTMLForm.equalsIgnoreCase(ct.getContentType());
    }

    public static boolean isMultiPartForm(ContentType ct) {
        return contentTypeMultipartFormData.equalsIgnoreCase(ct.getContentType());
    }

    public static ContentType determineCT(String contentTypeStr, Lang hintLang, String target) {
        boolean isTextPlain = "text/plain".equals(contentTypeStr);
        if (contentTypeStr != null) {
            contentTypeStr = WebContent.contentTypeCanonical(contentTypeStr);
        }
        ContentType ct = null;
        if (!isTextPlain) {
            ContentType contentType = ct = contentTypeStr == null ? null : ContentType.create(contentTypeStr);
        }
        if (ct == null && hintLang != null) {
            ct = hintLang.getContentType();
        }
        if (ct == null) {
            ct = RDFLanguages.guessContentType(target);
        }
        return ct;
    }
}

