/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb;

import java.sql.Connection;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sdb.SDB;
import org.apache.jena.sdb.Store;
import org.apache.jena.sdb.StoreDesc;
import org.apache.jena.sdb.graph.GraphSDB;
import org.apache.jena.sdb.sql.SDBConnection;
import org.apache.jena.sdb.sql.SDBConnectionDesc;
import org.apache.jena.sdb.sql.SDBConnectionFactory;
import org.apache.jena.sdb.store.DatasetGraphSDB;
import org.apache.jena.sdb.store.DatasetStore;
import org.apache.jena.sdb.store.StoreFactory;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.modify.GraphStoreBasic;
import org.apache.jena.system.JenaSystem;
import org.apache.jena.update.GraphStore;

public class SDBFactory {
    public static SDBConnection createConnection(String jdbcURL, String user, String password) {
        return SDBConnectionFactory.create(jdbcURL, user, password);
    }

    public static SDBConnection createConnection(SDBConnectionDesc desc) {
        return SDBConnectionFactory.create(desc);
    }

    public static SDBConnection createConnection(Connection conn) {
        return SDBConnectionFactory.create(conn);
    }

    public static SDBConnection createConnection(String configFile) {
        return SDBConnectionFactory.create(configFile);
    }

    public static Connection createSqlConnection(SDBConnectionDesc desc) {
        return SDBConnectionFactory.createSqlConnection(desc);
    }

    public static Connection createSqlConnection(String configFile) {
        return SDBConnectionFactory.createJDBC(configFile);
    }

    public static Connection createSqlConnection(Model model) {
        return SDBConnectionFactory.createJDBC(model);
    }

    public static Store connectStore(String configFile) {
        return StoreFactory.create(configFile);
    }

    public static Store connectStore(StoreDesc desc) {
        return StoreFactory.create(desc);
    }

    public static Store connectStore(SDBConnection sdbConnection, StoreDesc desc) {
        return StoreFactory.create(desc, sdbConnection);
    }

    public static Store connectStore(Connection sqlConnection, StoreDesc desc) {
        SDBConnection sdb = SDBConnectionFactory.create(sqlConnection);
        return StoreFactory.create(desc, sdb);
    }

    public static Dataset connectDataset(Store store) {
        return DatasetStore.create(store);
    }

    public static Dataset connectDataset(StoreDesc desc) {
        return DatasetStore.create(SDBFactory.connectStore(desc));
    }

    public static Dataset connectDataset(SDBConnection sdbConnection, StoreDesc desc) {
        return DatasetStore.create(SDBFactory.connectStore(sdbConnection, desc));
    }

    public static Dataset connectDataset(Connection jdbcConnection, StoreDesc desc) {
        return DatasetStore.create(SDBFactory.connectStore(jdbcConnection, desc));
    }

    public static Dataset connectDataset(String configFile) {
        return DatasetStore.create(SDBFactory.connectStore(configFile));
    }

    public static DatasetGraph connectDatasetGraph(Store store) {
        return new DatasetGraphSDB(store, SDB.getContext().copy());
    }

    @Deprecated
    public static GraphStore connectGraphStore(Store store) {
        return new GraphStoreBasic(SDBFactory.connectDatasetGraph(store));
    }

    public static DatasetGraph connectDatasetGraph(StoreDesc desc) {
        return SDBFactory.connectDatasetGraph(SDBFactory.connectStore(desc));
    }

    @Deprecated
    public static GraphStore connectGraphStore(StoreDesc desc) {
        return SDBFactory.connectGraphStore(SDBFactory.connectStore(desc));
    }

    public static DatasetGraph connectDatasetGraph(SDBConnection sdbConnection, StoreDesc desc) {
        return SDBFactory.connectDatasetGraph(SDBFactory.connectStore(sdbConnection, desc));
    }

    @Deprecated
    public static GraphStore connectGraphStore(SDBConnection sdbConnection, StoreDesc desc) {
        return SDBFactory.connectGraphStore(SDBFactory.connectStore(sdbConnection, desc));
    }

    public static DatasetGraph connectDatasetGraph(Connection jdbcConnection, StoreDesc desc) {
        return SDBFactory.connectDatasetGraph(SDBFactory.connectStore(jdbcConnection, desc));
    }

    @Deprecated
    public static GraphStore connectGraphStore(Connection jdbcConnection, StoreDesc desc) {
        return SDBFactory.connectGraphStore(SDBFactory.connectStore(jdbcConnection, desc));
    }

    public static DatasetGraph connectDatasetGraph(String configFile) {
        return SDBFactory.connectDatasetGraph(SDBFactory.connectStore(configFile));
    }

    @Deprecated
    public static GraphStore connectGraphStore(String configFile) {
        return SDBFactory.connectGraphStore(SDBFactory.connectStore(configFile));
    }

    public static Graph connectDefaultGraph(String configFile) {
        return SDBFactory.connectDefaultGraph(StoreFactory.create(configFile));
    }

    public static Graph connectDefaultGraph(StoreDesc desc) {
        return SDBFactory.connectDefaultGraph(StoreFactory.create(desc));
    }

    public static Graph connectDefaultGraph(Store store) {
        return new GraphSDB(store);
    }

    public static Graph connectNamedGraph(String configFile, String iri2) {
        return SDBFactory.connectNamedGraph(StoreFactory.create(configFile), iri2);
    }

    public static Graph connectNamedGraph(StoreDesc desc, String iri2) {
        return SDBFactory.connectNamedGraph(StoreFactory.create(desc), iri2);
    }

    public static Graph connectNamedGraph(Store store, String iri2) {
        return new GraphSDB(store, iri2);
    }

    public static Graph connectNamedGraph(String configFile, Node node) {
        return SDBFactory.connectNamedGraph(StoreFactory.create(configFile), node);
    }

    public static Graph connectNamedGraph(StoreDesc desc, Node node) {
        return SDBFactory.connectNamedGraph(StoreFactory.create(desc), node);
    }

    public static Graph connectNamedGraph(Store store, Node node) {
        return new GraphSDB(store, node);
    }

    public static Model connectDefaultModel(String configFile) {
        return SDBFactory.connectDefaultModel(StoreFactory.create(configFile));
    }

    public static Model connectDefaultModel(StoreDesc desc) {
        return SDBFactory.connectDefaultModel(StoreFactory.create(desc));
    }

    public static Model connectDefaultModel(Store store) {
        return SDBFactory.createModelSDB(store);
    }

    public static Model connectNamedModel(StoreDesc desc, String iri2) {
        return SDBFactory.connectNamedModel(StoreFactory.create(desc), iri2);
    }

    public static Model connectNamedModel(Store store, String iri2) {
        return SDBFactory.createModelSDB(store, iri2);
    }

    public static Model connectNamedModel(String configFile, String iri2) {
        return SDBFactory.connectNamedModel(StoreFactory.create(configFile), iri2);
    }

    public static Model connectNamedModel(StoreDesc desc, Resource resource) {
        return SDBFactory.connectNamedModel(StoreFactory.create(desc), resource);
    }

    public static Model connectNamedModel(Store store, Resource resource) {
        return SDBFactory.createModelSDB(store, resource);
    }

    public static Model connectNamedModel(String configFile, Resource resource) {
        return SDBFactory.connectNamedModel(StoreFactory.create(configFile), resource);
    }

    private static Model createModelSDB(Store store) {
        return ModelFactory.createModelForGraph(new GraphSDB(store));
    }

    private static Model createModelSDB(Store store, String iri2) {
        return ModelFactory.createModelForGraph(new GraphSDB(store, iri2));
    }

    private static Model createModelSDB(Store store, Resource resource) {
        return ModelFactory.createModelForGraph(new GraphSDB(store, resource.asNode()));
    }

    static {
        JenaSystem.init();
    }
}

