/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.compiler;

import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.query.Query;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sdb.SDB;
import org.apache.jena.sdb.compiler.OpSQL;
import org.apache.jena.sdb.core.SDBRequest;
import org.apache.jena.sdb.core.sqlnode.SqlNode;
import org.apache.jena.sdb.sql.ResultSetJDBC;
import org.apache.jena.sdb.sql.SDBExceptionSQL;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDB_QC {
    private static Logger log = LoggerFactory.getLogger(SDB_QC.class);
    public static boolean fetchPrint = false;
    public static boolean PrintSQL = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QueryIterator exec(OpSQL opSQL, SDBRequest request, Binding binding, ExecutionContext execCxt) {
        String sqlStmtStr = SDB_QC.toSqlString(opSQL, request);
        if (PrintSQL) {
            System.out.println(sqlStmtStr);
        }
        String str2 = null;
        if (execCxt != null) {
            str2 = execCxt.getContext().getAsString(SDB.jdbcFetchSize);
        }
        int fetchSize = -1;
        if (str2 != null) {
            try {
                fetchSize = Integer.parseInt(str2);
            }
            catch (NumberFormatException ex) {
                log.warn("Bad number for fetch size: " + str2);
            }
        }
        ResultSetJDBC jdbcResultSet = request.getStore().getConnection().execQuery(sqlStmtStr, fetchSize);
        try {
            if (opSQL.getBridge() == null) {
                log.error("Null bridge");
            }
            QueryIterator queryIterator = opSQL.getBridge().assembleResults(jdbcResultSet, binding, execCxt);
            jdbcResultSet = null;
            return queryIterator;
        }
        catch (Throwable throwable) {
            try {
                jdbcResultSet = null;
                throw throwable;
            }
            catch (SQLException ex) {
                throw new SDBExceptionSQL("SQLException in executing SQL statement", ex);
            }
        }
    }

    public static String toSqlString(OpSQL opSQL, SDBRequest request) {
        SqlNode sqlNode = opSQL.getSqlNode();
        String sqlStmt = request.getStore().getSQLGenerator().generateSQL(request, sqlNode);
        return sqlStmt;
    }

    public static List<Var> queryOutVars(Query query2) {
        List<Var> vars = Iter.toList(Iter.map(query2.getResultVars().iterator(), Var::alloc));
        List<SortCondition> orderConditions = query2.getOrderBy();
        if (orderConditions != null) {
            for (SortCondition sc : orderConditions) {
                Set<Var> x = sc.getExpression().getVarsMentioned();
                for (Var v : x) {
                    if (vars.contains(v)) continue;
                    vars.add(v);
                }
            }
        }
        return vars;
    }

    public static boolean isOpSQL(Op x) {
        return x instanceof OpSQL;
    }
}

