/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.layout2;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sdb.SDBException;
import org.apache.jena.sdb.Store;
import org.apache.jena.sdb.sql.SDBConnection;
import org.apache.jena.sdb.sql.SDBConnectionHolder;
import org.apache.jena.sdb.sql.SDBExceptionSQL;
import org.apache.jena.sdb.store.StoreLoaderPlus;
import org.apache.jena.sdb.store.TableDesc;
import org.apache.jena.sdb.store.TupleLoader;
import org.apache.jena.sparql.core.Quad;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoaderTuplesNodes
extends SDBConnectionHolder
implements StoreLoaderPlus {
    private static Logger log = LoggerFactory.getLogger(LoaderTuplesNodes.class);
    private boolean initialized = false;
    boolean threading = true;
    Thread commitThread = null;
    static final TupleChange flushSignal = new TupleChange();
    static final TupleChange finishSignal = new TupleChange();
    ArrayBlockingQueue<TupleChange> queue;
    AtomicReference<Throwable> threadException;
    Object threadFlushing = new Object();
    Map<String, TupleLoader> tupleLoaders;
    TupleLoader currentLoader;
    int count;
    int chunkSize = 20000;
    private Class<? extends TupleLoader> tupleLoaderClass;
    private Store store;

    public LoaderTuplesNodes(SDBConnection connection, Class<? extends TupleLoader> tupleLoaderClass) {
        super(connection);
        this.tupleLoaderClass = tupleLoaderClass;
    }

    public void setStore(Store store) {
        this.store = store;
    }

    @Override
    public void startBulkUpdate() {
        this.init();
    }

    @Override
    public void finishBulkUpdate() {
        this.flushTriples();
    }

    @Override
    public void close() {
        if (!this.initialized) {
            return;
        }
        try {
            if (this.threading && this.commitThread.isAlive()) {
                this.queue.put(finishSignal);
                this.commitThread.join();
            } else {
                this.flushTriples();
            }
        }
        catch (Exception e2) {
            log.error("Problem closing loader: " + e2.getMessage());
            throw new SDBException("Problem closing loader", e2);
        }
        finally {
            for (TupleLoader loader : this.tupleLoaders.values()) {
                loader.close();
            }
            this.initialized = false;
            this.commitThread = null;
            this.queue = null;
            this.tupleLoaderClass = null;
            this.tupleLoaders = null;
        }
    }

    @Override
    public void addTriple(Triple triple) {
        this.addTuple(this.store.getTripleTableDesc(), triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    @Override
    public void deleteTriple(Triple triple) {
        this.deleteTuple(this.store.getTripleTableDesc(), triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    @Override
    public void addQuad(Node g, Node s, Node p, Node o) {
        if (g == Quad.tripleInQuad || Quad.isDefaultGraph(o)) {
            this.addTuple(this.store.getTripleTableDesc(), s, p, o);
        } else {
            this.addTuple(this.store.getQuadTableDesc(), g, s, p, o);
        }
    }

    @Override
    public void addTuple(TableDesc t, Node ... nodes) {
        this.updateStore(new TupleChange(true, t, nodes));
    }

    @Override
    public void deleteQuad(Node g, Node s, Node p, Node o) {
        if (g == Quad.tripleInQuad || Quad.isDefaultGraph(o)) {
            this.deleteTuple(this.store.getTripleTableDesc(), s, p, o);
        } else {
            this.deleteTuple(this.store.getQuadTableDesc(), g, s, p, o);
        }
    }

    @Override
    public void deleteTuple(TableDesc t, Node ... nodes) {
        this.updateStore(new TupleChange(false, t, nodes));
    }

    @Override
    public void deleteAll() {
        this.updateStore(new TupleChange(false, this.store.getTripleTableDesc(), new Node[0]));
    }

    @Override
    public void deleteAll(Node graph) {
        this.updateStore(new TupleChange(false, this.store.getQuadTableDesc(), graph));
    }

    private void updateStore(TupleChange tuple) {
        if (this.threading) {
            this.checkThreadStatus();
            try {
                this.queue.put(tuple);
            }
            catch (InterruptedException e2) {
                log.error("Issue adding to queue: " + e2.getMessage());
                throw new SDBException("Issue adding to queue" + e2.getMessage(), e2);
            }
        } else {
            this.updateOneTuple(tuple);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushTriples() {
        if (this.threading) {
            if (!this.commitThread.isAlive()) {
                throw new SDBException("Thread has died");
            }
            try {
                Object object = this.threadFlushing;
                synchronized (object) {
                    this.queue.put(flushSignal);
                    this.threadFlushing.wait();
                }
            }
            catch (InterruptedException e2) {
                log.error("Problem sending flush signal: " + e2.getMessage());
                throw new SDBException("Problem sending flush signal", e2);
            }
            this.checkThreadStatus();
        } else {
            this.commitTuples();
        }
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        this.tupleLoaders = new HashMap<String, TupleLoader>();
        this.currentLoader = null;
        this.count = 0;
        if (this.threading) {
            this.queue = new ArrayBlockingQueue(this.chunkSize);
            this.threadException = new AtomicReference();
            this.threadFlushing = new AtomicBoolean();
            this.commitThread = new Thread(new Commiter());
            this.commitThread.setDaemon(true);
            this.commitThread.start();
            log.debug("Threading started");
        }
        this.initialized = true;
    }

    private void checkThreadStatus() {
        Throwable e2 = this.threadException.getAndSet(null);
        if (e2 != null) {
            if (e2 instanceof SQLException) {
                throw new SDBExceptionSQL("Loader thread exception", (SQLException)e2);
            }
            if (e2 instanceof RuntimeException) {
                throw (RuntimeException)e2;
            }
            throw new SDBException("Loader thread exception", e2);
        }
        if (!this.commitThread.isAlive()) {
            throw new SDBException("Thread has died");
        }
    }

    private void updateOneTuple(TupleChange tuple) {
        if (this.currentLoader == null || !this.currentLoader.getTableDesc().getTableName().equals(tuple.table.getTableName())) {
            this.commitTuples();
            this.currentLoader = this.tupleLoaders.get(tuple.table.getTableName());
            if (this.currentLoader == null) {
                try {
                    this.currentLoader = this.tupleLoaderClass.getConstructor(SDBConnection.class, TableDesc.class, Integer.TYPE).newInstance(this.connection(), tuple.table, this.chunkSize);
                }
                catch (Exception e2) {
                    throw new SDBException("Problem making new tupleloader", e2);
                }
                this.currentLoader.start();
                this.tupleLoaders.put(tuple.table.getTableName(), this.currentLoader);
            }
        }
        if (tuple.toAdd) {
            this.currentLoader.load(tuple.tuple);
        } else {
            this.currentLoader.unload(tuple.tuple);
        }
    }

    private void commitTuples() {
        if (this.currentLoader != null) {
            this.currentLoader.finish();
        }
    }

    @Override
    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    @Override
    public int getChunkSize() {
        return this.chunkSize;
    }

    @Override
    public void setUseThreading(boolean useThreading) {
        this.threading = useThreading;
    }

    @Override
    public boolean getUseThreading() {
        return this.threading;
    }

    class Commiter
    implements Runnable {
        Commiter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            log.debug("Running loader thread");
            LoaderTuplesNodes.this.threadException.set(null);
            block9: while (true) {
                try {
                    while (true) {
                        TupleChange tuple;
                        if ((tuple = LoaderTuplesNodes.this.queue.take()) == flushSignal) {
                            Object object = LoaderTuplesNodes.this.threadFlushing;
                            synchronized (object) {
                                try {
                                    LoaderTuplesNodes.this.commitTuples();
                                }
                                catch (Throwable e2) {
                                    this.handleIssue(e2);
                                }
                                LoaderTuplesNodes.this.threadFlushing.notify();
                                continue block9;
                            }
                        }
                        if (tuple == finishSignal) {
                            try {
                                LoaderTuplesNodes.this.commitTuples();
                            }
                            catch (Throwable e3) {
                                this.handleIssue(e3);
                            }
                            break block9;
                        }
                        LoaderTuplesNodes.this.updateOneTuple(tuple);
                    }
                }
                catch (Throwable e4) {
                    this.handleIssue(e4);
                    continue;
                }
                break;
            }
        }

        private void handleIssue(Throwable e2) {
            log.error("Error in thread: " + e2.getMessage(), e2);
            LoaderTuplesNodes.this.threadException.set(e2);
        }
    }

    static class TupleChange {
        public Node[] tuple;
        public boolean toAdd;
        public TableDesc table;

        public TupleChange(boolean toAdd, TableDesc table, Node ... tuple) {
            this.tuple = tuple;
            this.toAdd = toAdd;
            this.table = table;
        }

        public TupleChange() {
            this.tuple = null;
            this.table = null;
            this.toAdd = false;
        }
    }
}

