/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.store;

import java.util.List;
import org.apache.jena.sdb.SDBException;
import org.apache.jena.sdb.shared.SymbolRegistry;
import org.apache.jena.sparql.util.Named;
import org.apache.jena.sparql.util.Symbol;
import org.slf4j.LoggerFactory;

public class DatabaseType
extends Symbol
implements Named {
    public static final DatabaseType Derby = new DatabaseType("derby");
    public static final DatabaseType H2 = new DatabaseType("H2");
    public static final DatabaseType HSQLDB = new DatabaseType("HSQLDB");
    public static final DatabaseType MySQL = new DatabaseType("MySQL");
    public static final DatabaseType MariaDB = new DatabaseType("MariaDB");
    public static final DatabaseType PostgreSQL = new DatabaseType("PostgreSQL");
    public static final DatabaseType SQLServer = new DatabaseType("SQLServer");
    public static final DatabaseType Oracle = new DatabaseType("Oracle");
    public static final DatabaseType DB2 = new DatabaseType("DB2");
    public static final DatabaseType SAP = new DatabaseType("sap");
    static SymbolRegistry<DatabaseType> registry = new SymbolRegistry();

    public static DatabaseType fetch(String databaseTypeName) {
        if (databaseTypeName == null) {
            throw new IllegalArgumentException("DatabaseType.convert: null not allowed");
        }
        DatabaseType t = registry.lookup(databaseTypeName);
        if (t != null) {
            return t;
        }
        if (databaseTypeName.startsWith("oracle:")) {
            return Oracle;
        }
        LoggerFactory.getLogger(DatabaseType.class).warn("Can't turn '" + databaseTypeName + "' into a database type");
        throw new SDBException("Can't turn '" + databaseTypeName + "' into a database type");
    }

    static void init() {
        DatabaseType.register(Derby);
        DatabaseType.registerName("JavaDB", Derby);
        DatabaseType.register(HSQLDB);
        DatabaseType.registerName("hsqldb:file", HSQLDB);
        DatabaseType.registerName("hsqldb:mem", HSQLDB);
        DatabaseType.registerName("hsql", HSQLDB);
        DatabaseType.register(H2);
        DatabaseType.registerName("h2:file", H2);
        DatabaseType.registerName("h2:mem", H2);
        DatabaseType.registerName("h2:tcp", H2);
        DatabaseType.registerName("h2", H2);
        DatabaseType.register(MySQL);
        DatabaseType.register(MariaDB);
        DatabaseType.registerName("MySQL5", MySQL);
        DatabaseType.register(PostgreSQL);
        DatabaseType.register(SQLServer);
        DatabaseType.registerName("MSSQLServer", SQLServer);
        DatabaseType.registerName("MSSQLServerExpress", SQLServer);
        DatabaseType.register(Oracle);
        DatabaseType.register(DB2);
        DatabaseType.register(SAP);
    }

    public static List<String> allNames() {
        return registry.allNames();
    }

    public static List<DatabaseType> allTypes() {
        return registry.allSymbols();
    }

    public static void register(String name) {
        if (name == null) {
            throw new IllegalArgumentException("DatabaseType.register(String): null not allowed");
        }
        DatabaseType.register(new DatabaseType(name));
    }

    public static void register(DatabaseType dbType) {
        if (dbType == null) {
            throw new IllegalArgumentException("DatabaseType.register(DatabaseType): null not allowed");
        }
        registry.register(dbType);
    }

    public static void registerName(String databaseName, DatabaseType dbType) {
        if (dbType == null) {
            throw new IllegalArgumentException("DatabaseType.registerName: null not allowed");
        }
        registry.register(databaseName, dbType);
    }

    private DatabaseType(String layoutName) {
        super(layoutName);
    }

    @Override
    public String getName() {
        return super.getSymbol();
    }

    static {
        DatabaseType.init();
    }
}

