/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.assembler;

import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.assemblers.AssemblerGroup;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sdb.assembler.DatasetStoreAssembler;
import org.apache.jena.sdb.assembler.QueryAssembler;
import org.apache.jena.sdb.assembler.SDBConnectionDescAssembler;
import org.apache.jena.sdb.assembler.SDBModelAssembler;
import org.apache.jena.sdb.assembler.StoreDescAssembler;
import org.apache.jena.sdb.util.Vocab;

public class AssemblerVocab {
    private static final String NS = "http://jena.hpl.hp.com/2007/sdb#";
    public static final Resource SDBConnectionAssemblerType = Vocab.type("http://jena.hpl.hp.com/2007/sdb#", "SDBConnection");
    public static final Resource StoreAssemblerType = Vocab.type("http://jena.hpl.hp.com/2007/sdb#", "Store");
    public static final Resource DatasetAssemblerType = Vocab.type("http://jena.hpl.hp.com/2007/sdb#", "DatasetStore");
    public static final Resource ModelType = Vocab.type("http://jena.hpl.hp.com/2007/sdb#", "Model");
    public static final Resource GraphType = Vocab.type("http://jena.hpl.hp.com/2007/sdb#", "Graph");
    public static final Property pStore = Vocab.property("http://jena.hpl.hp.com/2007/sdb#", "store");
    public static final Property pDataset = Vocab.property("http://jena.hpl.hp.com/2007/sdb#", "dataset");
    public static final Property pGraphData = Vocab.property("http://jena.hpl.hp.com/2007/sdb#", "graph");
    public static final Property pNamedGraph1 = Vocab.property("http://jena.hpl.hp.com/2007/sdb#", "graphName");
    public static final Property pNamedGraph2 = Vocab.property("http://jena.hpl.hp.com/2007/sdb#", "namedGraph");
    public static final Property pSteps = Vocab.property("http://jena.hpl.hp.com/2007/sdb#", "steps");
    public static final Property pMain = Vocab.property("http://jena.hpl.hp.com/2007/sdb#", "main");
    public static final Property pClassname = Vocab.property("http://jena.hpl.hp.com/2007/sdb#", "classname");
    public static final Property pArgs = Vocab.property("http://jena.hpl.hp.com/2007/sdb#", "args");
    public static final Property pArgName = Vocab.property("http://jena.hpl.hp.com/2007/sdb#", "name");
    public static final Property pArgValue = Vocab.property("http://jena.hpl.hp.com/2007/sdb#", "value");
    public static final Resource QueryAssemblerType = Vocab.type("http://jena.hpl.hp.com/2007/sdb#", "Query");
    public static final Property pQuery = Vocab.property("http://jena.hpl.hp.com/2007/sdb#", "query");
    public static final Property pQueryFile = Vocab.property("http://jena.hpl.hp.com/2007/sdb#", "queryFile");
    public static final Property pQueryString = Vocab.property("http://jena.hpl.hp.com/2007/sdb#", "queryString");
    public static final Property pOutputFormat = Vocab.property("http://jena.hpl.hp.com/2007/sdb#", "outputFormat");
    public static final Property pDriver = Vocab.property("http://jena.hpl.hp.com/2007/sdb#", "driver");
    public static final Property pSDBtype = Vocab.property("http://jena.hpl.hp.com/2007/sdb#", "sdbType");
    public static final Property pSDBhost = Vocab.property("http://jena.hpl.hp.com/2007/sdb#", "sdbHost");
    public static final Property pSDBname = Vocab.property("http://jena.hpl.hp.com/2007/sdb#", "sdbName");
    public static final Property pJDBC = Vocab.property("http://jena.hpl.hp.com/2007/sdb#", "jdbcURL");
    public static final Property pPoolSize = Vocab.property("http://jena.hpl.hp.com/2007/sdb#", "poolSize");
    public static final Property pSDBuser = Vocab.property("http://jena.hpl.hp.com/2007/sdb#", "sdbUser");
    public static final Property pSDBpassword = Vocab.property("http://jena.hpl.hp.com/2007/sdb#", "sdbPassword");
    public static final Property pLayout = Vocab.property("http://jena.hpl.hp.com/2007/sdb#", "layout");
    public static final Property pConnection = Vocab.property("http://jena.hpl.hp.com/2007/sdb#", "connection");
    public static final Property featureProperty = Vocab.property("http://jena.hpl.hp.com/2007/sdb#", "feature");
    public static final Property featureNameProperty = Vocab.property("http://jena.hpl.hp.com/2007/sdb#", "name");
    public static final Property featureValueProperty = Vocab.property("http://jena.hpl.hp.com/2007/sdb#", "value");
    public static final Property pMySQLEngine = Vocab.property("http://jena.hpl.hp.com/2007/sdb#", "engine");
    public static final Property pStorageType = Vocab.property("http://jena.hpl.hp.com/2007/sdb#", "storage");
    private static boolean initialized = false;

    public static String getURI() {
        return NS;
    }

    public static void init() {
        if (initialized) {
            return;
        }
        AssemblerVocab.register(Assembler.general);
        initialized = true;
    }

    public static void register(AssemblerGroup g) {
        AssemblerVocab.assemblerClass(g, QueryAssemblerType, new QueryAssembler());
        AssemblerVocab.assemblerClass(g, SDBConnectionAssemblerType, new SDBConnectionDescAssembler());
        AssemblerVocab.assemblerClass(g, StoreAssemblerType, new StoreDescAssembler());
        AssemblerVocab.assemblerClass(g, DatasetAssemblerType, new DatasetStoreAssembler());
        AssemblerVocab.assemblerClass(g, ModelType, new SDBModelAssembler());
        AssemblerVocab.assemblerClass(g, GraphType, new SDBModelAssembler());
    }

    private static void assemblerClass(AssemblerGroup g, Resource r, Assembler a) {
        if (g == null) {
            g = Assembler.general;
        }
        g.implementWith(r, a);
    }

    static {
        AssemblerVocab.init();
    }
}

