/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.assembler;

import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sdb.SDBFactory;
import org.apache.jena.sdb.StoreDesc;
import org.apache.jena.sdb.assembler.AssemblerVocab;
import org.apache.jena.sdb.assembler.DatasetStoreAssembler;
import org.apache.jena.sdb.assembler.MissingException;
import org.apache.jena.sparql.util.graph.GraphUtils;

public class SDBModelAssembler
extends AssemblerBase
implements Assembler {
    DatasetStoreAssembler datasetAssem = new DatasetStoreAssembler();

    @Override
    public Model open(Assembler a, Resource root2, Mode mode) {
        Resource dataset = GraphUtils.getResourceValue(root2, AssemblerVocab.pDataset);
        if (dataset == null) {
            throw new MissingException(root2, "No dataset for model or graph");
        }
        StoreDesc storeDesc = this.datasetAssem.openStore(a, dataset, mode);
        String x = GraphUtils.getAsStringValue(root2, AssemblerVocab.pNamedGraph1);
        if (x == null) {
            x = GraphUtils.getAsStringValue(root2, AssemblerVocab.pNamedGraph2);
        }
        Object g = null;
        if (x == null) {
            return SDBFactory.connectDefaultModel(storeDesc);
        }
        return SDBFactory.connectNamedModel(storeDesc, x);
    }
}

