/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.compiler;

import java.util.ArrayList;
import java.util.function.Consumer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.io.PrintUtils;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Node;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.util.PrintSerializable;
import org.apache.jena.sparql.util.QueryOutputUtils;

public class QuadBlock
extends ArrayList<Quad>
implements Iterable<Quad>,
PrintSerializable {
    Node graphNode;
    private static Quad[] qArrayTemplate = new Quad[0];

    public QuadBlock() {
    }

    public QuadBlock(QuadBlock other) {
        super(other);
        this.graphNode = other.graphNode;
    }

    public QuadBlock(OpQuadPattern quadPattern) {
        this.addAll(quadPattern.getPattern().getList());
        this.graphNode = quadPattern.getGraphNode();
    }

    @Override
    public QuadBlock clone() {
        return new QuadBlock(this);
    }

    public Quad[] asArray() {
        return this.toArray(qArrayTemplate);
    }

    public Node getGraphNode() {
        return this.graphNode;
    }

    public boolean contains(Quad pattern) {
        return this.contains(pattern.getGraph(), pattern.getSubject(), pattern.getPredicate(), pattern.getObject());
    }

    public boolean contains(Node g, Node s, Node p, Node o) {
        return this.findFirst(g, s, p, o) >= 0;
    }

    public int findFirst(Quad pattern) {
        return this.findFirst(0, pattern);
    }

    public int findFirst(Node g, Node s, Node p, Node o) {
        return this.findFirst(0, g, s, p, o);
    }

    public int findFirst(int start, Quad pattern) {
        return this.findFirst(start, pattern.getGraph(), pattern.getSubject(), pattern.getPredicate(), pattern.getObject());
    }

    public int findFirst(int start, Node g, Node s, Node p, Node o) {
        if (g == Node.ANY) {
            g = null;
        }
        if (s == Node.ANY) {
            s = null;
        }
        if (p == Node.ANY) {
            p = null;
        }
        if (o == Node.ANY) {
            o = null;
        }
        for (int i = start; i < this.size(); ++i) {
            Quad q = (Quad)this.get(i);
            if (!QuadBlock.matchOne(g, s, p, o, q)) continue;
            return i;
        }
        return -1;
    }

    public QuadBlock subBlock(int fromIndex, int toIndex) {
        QuadBlock slice = new QuadBlock();
        slice.addAll(this.subList(fromIndex, toIndex));
        return slice;
    }

    public QuadBlock subBlock(int fromIndex) {
        QuadBlock slice = new QuadBlock();
        slice.addAll(this.subList(fromIndex, this.size()));
        return slice;
    }

    public Iterable<Quad> find(Quad pattern) {
        return this.find(pattern.getGraph(), pattern.getSubject(), pattern.getPredicate(), pattern.getObject());
    }

    public Iterable<Quad> find(Node g, Node s, Node p, Node o) {
        ArrayList<Quad> matches = new ArrayList<Quad>();
        if (g == Node.ANY) {
            g = null;
        }
        if (s == Node.ANY) {
            s = null;
        }
        if (p == Node.ANY) {
            p = null;
        }
        if (o == Node.ANY) {
            o = null;
        }
        for (Quad q : this) {
            if (!QuadBlock.matchOne(g, s, p, o, q)) continue;
            matches.add(q);
        }
        return matches;
    }

    private static boolean matchOne(Node g, Node s, Node p, Node o, Quad q) {
        return !(p != null && !p.equals(q.getPredicate()) || s != null && !s.equals(q.getSubject()) || o != null && !o.equals(q.getObject()) || g != null && !g.equals(q.getGraph()));
    }

    @Override
    public String toString() {
        return PrintUtils.toString(this);
    }

    @Override
    public void output(final IndentedWriter out, SerializationContext sCxt) {
        String sep = "\n";
        Consumer<Quad> strAction = new Consumer<Quad>(){
            boolean first = true;

            @Override
            public void accept(Quad quad) {
                if (!this.first) {
                    out.print("\n");
                }
                this.first = false;
                out.print(String.valueOf(quad));
            }
        };
        Iter.apply(this.iterator(), strAction);
    }

    @Override
    public String toString(PrefixMapping prefixMapping) {
        return QueryOutputUtils.toString(this, prefixMapping);
    }

    @Override
    public void output(IndentedWriter out) {
        String x = QueryOutputUtils.toString(this);
        out.print(x);
    }
}

